import java.io.*;
import java.util.*;

public class SuperFile extends File {
	private String sAttr = "";
	private boolean bAttrInited = false;

	public int compareTo(Object o) {
		if (o instanceof SuperFile) {
			SuperFile sf = (SuperFile)o;
			if (!super.equals(o)) {
				return 1;
			}
			if (bAttrInited != sf.bAttrInited) {
				return 1;
			}
			if (bAttrInited) {
				if (sAttr != sf.sAttr) {
					return 1;
				}
			}
			return 0;
		}
		return 1;
	}

	public SuperFile(String pathname) {
		super(pathname);
	}

	public SuperFile(String parent, String child) {
		super(parent, child);
	}

	public SuperFile(File parent, String child) {
		super(parent, child);
	}

	public String getAttrs() {
		if(bAttrInited) return sAttr;

		StringBuffer sb = new StringBuffer();
		sb.append(isDirectory() ? "D" : "-");
		sb.append(canRead() ? "R" : "-");
		sb.append(canWrite() ? "W" : "-");
		sAttr = sb.toString();
		bAttrInited = true;
		return sAttr;
	}

	public SuperFile[] listSuperFiles() {
		String[] ss = list();
		if (ss == null) return null;
		int n = ss.length;
		SuperFile[] fs = new SuperFile[n];
		for (int i = 0; i < n; i++) {
			 fs[i] = new SuperFile(getPath(), ss[i]);
		}
		return fs;
	}

	public File[] listFiles() {
		String[] ss = list();
		if (ss == null) return null;
		int n = ss.length;
		File[] fs = new File[n];
		for (int i = 0; i < n; i++) {
			 fs[i] = new File(getPath(), ss[i]);
		}
		return fs;
	}

	public long length() {
		if(isDirectory()) return -1;
		else return super.length();
	}

	private String sLength = "";
	private boolean bLengthInited = false;

	public String getFileSize() {
		if(bLengthInited) {return sLength;}

		sLength = getFileSize(length());
		bLengthInited = true;
		return sLength;
	}

	public static String getFileSize(long size) {
		String temp = Long.toString(size);
		StringBuffer sb = new StringBuffer();
		int c = 0;
		for(int i=temp.length()-1;i>=0;i--){
			 if((c%3 == 0)&&(c!=0)) sb.insert(0, ',');
			 sb.insert(0, temp.charAt(i));
			 c++;
		}
		return sb.toString();
	}

	private String sDate = "";
	private boolean bDateInited = false;

	public String getLastModified() {
		if(bDateInited) return sDate;

		sDate = getLastModified(lastModified());
		bDateInited = true;
		return sDate;
	}

	public static String getLastModified(long l) {
		MyGregorianCalendar c = new MyGregorianCalendar();
		c.setTimeLong(l);
		return getLastModified(c);
	}

	public static String getLastModified(Calendar c) {
		int x;
		StringBuffer sb = new StringBuffer();
		sb.append( MyGregorianCalendar.daysOfWeek[c.get(Calendar.DAY_OF_WEEK)] );
		sb.append(" ");
		sb.append( MyGregorianCalendar.months[c.get(Calendar.MONTH)] );
		sb.append(" ");
		x = c.get(Calendar.DAY_OF_MONTH);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(" ");
		x = c.get(Calendar.HOUR_OF_DAY);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(":");
		x = c.get(Calendar.MINUTE);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(":");
		x = c.get(Calendar.SECOND);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(" ");
		x = c.get(Calendar.YEAR);
		if(x < 10) sb.append("0");
		sb.append(x);
		return sb.toString();
	}

	private String sHttpDate;
	private boolean bHttpDateInited = false;

	public String getHttpLastModified() {
		if(bHttpDateInited) return sHttpDate;

		sHttpDate = getHttpLastModified(lastModified());
		bHttpDateInited = true;
		return sHttpDate;
	}

	public static String getHttpLastModified(long l) {
		MyGregorianCalendar c = new MyGregorianCalendar();
		c.setTimeLong(l);
		return getHttpLastModified(c);
	}

	public static String getHttpLastModified(Calendar c) {
		//HTTP/1.0 spec says we must have dates like so: Sun, 06 Nov 1994 08:49:37 GMT
		int x;
		StringBuffer sb = new StringBuffer();
		sb.append( MyGregorianCalendar.daysOfWeek[c.get(Calendar.DAY_OF_WEEK)] );
		sb.append(" ");

		x = c.get(Calendar.DAY_OF_MONTH);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(" ");

		sb.append( MyGregorianCalendar.months[c.get(Calendar.MONTH)] );
		sb.append(" ");

		x = c.get(Calendar.YEAR);
		sb.append(x);
		sb.append(" ");

		x = c.get(Calendar.HOUR_OF_DAY);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(":");
		x = c.get(Calendar.MINUTE);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(":");
		x = c.get(Calendar.SECOND);
		if(x < 10) sb.append("0");
		sb.append(x);
		sb.append(" GMT");

		return sb.toString();
	}

}
