import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;

public class GetAndHeadHandler {
    public static void handleCommand(
        RequestHandler rh
    ) {
        //data
        String sURI, sLocalFile;
        Properties prArguments = new Properties();
        int iTemp, iTemp2;
        String input = rh.getFirstLine();
        String temp, sArguments = "";
        VHostConf vhcHostConf = rh.getHostConf();

        //now get the url...
        rh.printDebugMessage(4, "input=="+input);

        iTemp = input.indexOf(' ');
        iTemp2 = input.indexOf("HTTP");
        if(iTemp2 == -1) {
            temp = input.substring(iTemp+1);
        } else {
            temp = input.substring(iTemp+1, iTemp2-1);
        }

        if(temp.equals("")) {
            rh.signalError(400);
            return;
        }

        rh.printDebugMessage(4, "temp=="+temp);
        /*  Now we should have a string like this:
            /bort.html?gorf=frog

            So, extract everything up to the ?, put that in m_sURI.
            Extract everything after the ? and put that in input.
        */
        iTemp = temp.indexOf("?");

        if(iTemp < 0) { //if we didn't find a ?, then we have no args
            sURI = temp;
        } else { //otherwise, look for arguments.
            sURI = temp.substring(0, iTemp);
            input = temp.substring(iTemp+1);
            sArguments = input;

            //And parse the arguments.
            try {
                StringTokenizer st = new StringTokenizer(input, "&", false);
                int i;
                String x;

                while(st.hasMoreTokens()) {
                    x = st.nextToken();
                    i = x.indexOf('=');
                    prArguments.put(x.substring(0, i), RequestHelper.decodeURL(x.substring(i+1) ));
                }
            } catch (Exception e) {
                rh.dumpException(e);
            }
        }

        //remove the encoded stuff (like %4F) and first slash...
        //from the URI (this hasn't anything to do with parsing arguments)
        sURI = RequestHelper.decodeURL(sURI);
        if(sURI.charAt(0) == '/') sLocalFile = sURI.substring(1);
        else sLocalFile = sURI;

        rh.printDebugMessage(3, "Local file == \""+sLocalFile+"\"");

        //Handle special files
        if(sLocalFile.startsWith("$VFS:/")) {  //something in the VFS.
            handleVFSFile(rh, sLocalFile, prArguments);
            return;
        } else if(sLocalFile.startsWith("cgi-bin/")) {  //something in the cgi-bin.
            handleCGIFile(rh, sLocalFile, sArguments);//, sLocalFile, prArguments);
            return;
        }

        String sFile = vhcHostConf.getDocumentRoot() + sLocalFile;

        rh.printDebugMessage(5, "Trying to access file: "+sFile);

        SuperFile f = new SuperFile(sFile);

        if(!f.exists()) {
            rh.signalError(404);
            return;
        }

        //If our path would take us up further than the site root, fail 403.
        try {
            if(!f.getCanonicalPath().toLowerCase().startsWith(vhcHostConf.getDocumentRoot().substring(0, vhcHostConf.getDocumentRoot().length()-1).toLowerCase())) {
                rh.signalError(403, 1, "");
                return;
            }
        } catch (IOException ee) {
            rh.dumpException(ee);
        }

        if( (f.isDirectory()) && (sURI.charAt(sURI.length()-1) != '/') ){
            rh.redirect(sURI+'/');
        } else if(f.isDirectory()) {
            sendFolder(rh, f, sURI, prArguments);
        } else {
            sendFile(rh, f);
        }
    }

    private static void handleVFSFile(
        RequestHandler rh,
        String sLocalFile,
        Properties prArguments
    ) {
        int iTemp = sLocalFile.indexOf('/');
        if(iTemp == -1) {
            rh.signalError(500); //ummm...this shouldn't occur...error!
            return;
        }

        rh.printDebugMessage(2, "Entering VFS...");

        String file = sLocalFile.substring(iTemp+1).toLowerCase();
        String sFile = rh.getHostConf().getVFSRoot() + file;

        if(file.equals ("folder.gif") ||
            file.equals("unknown.gif") ||
            file.equals("text.gif") ||
            file.equals("app.gif") ||
            file.equals("image.gif") ||
            file.equals("audio.gif") ||
            file.equals("video.gif") ||
            file.equals("style.css"))
        {
            SuperFile f = new SuperFile(sFile);
            try {
                rh.printDebugMessage(2, "VFS Object: "+f.getCanonicalPath());
            } catch (IOException e) {
                rh.dumpException(e);
            }

            if(!f.exists()) { //go 404 if no file!
                rh.signalError(404);
                return;
            }

            sendFile(rh, f);
            return;
        } else if(file.equals("stats.html")) {
            sendServerConfig(rh);
            return;
//        } else if(file.equals("kill.html")) {
//            System.exit(0);
        } else if(file.equals("log.txt")) {
            rh.printDebugMessage(2, "Sending Log...");

            SuperFile f = new SuperFile(rh.getHttpdConf().getNormalLogFile());
            sendFile(rh, f);
            return;
        } else if(file.equals("err.txt")) {
            rh.printDebugMessage(2, "Sending Error Log...");

            SuperFile f = new SuperFile(rh.getHttpdConf().getErrorLogFile());
            sendFile(rh, f);
            return;
        } else if(file.equals("sigerr")) {
            rh.printDebugMessage(2, "SIGERR...");

            try {
                rh.signalError(Integer.parseInt(prArguments.getProperty("err", "200")));
            } catch (IllegalArgumentException e) {
                rh.signalError(-1);
            }
            return;
        } else {
            rh.signalError(404);
            return;
        }
    }

    private static void sendFile(
        RequestHandler rh,
        SuperFile f
    ) {
        /*  REFRESH:

            Sending a file
              - If browser caching is on, then
                  - See if there is a If-Modified-Since header.
                  - If there is one, compare it against the file's last modified date.
                  - If there's no change, then
                      - send a 304 and exit
              - If the command is HEAD, then
                  - Exit.
              - If we've gotten here, that means that we need to send a file.
              - Emit a 200
              - If caching is enabled, then
                  - Emit a Last-Modified in the response header.
              - Emit the Content-Length
              - Look up the file's MIME type and send it in the Content-Type header.
              - Emit a blank line
              - Send the file.
        */
        VHostConf vhcHostConf = rh.getHostConf();

        if(vhcHostConf.isBrowserCachingEnabled()) {
            try {
                //get the if-modified-since
                String date = rh.getRequestHeaderValue("If-Modified-Since");//m_prHeaders.getProperty("If-Modified-Since");

                if(date != null) {
                    date = date.substring(0, date.indexOf("GMT"));

                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss");
                    sdf.setLenient(true);

                    MyGregorianCalendar filedate = new MyGregorianCalendar();
                    filedate.setTimeLong(f.lastModified());

                    MyGregorianCalendar requestdate = new MyGregorianCalendar();
                    try {
                        requestdate.setTime( sdf.parse(date) );
                    } catch (ParseException pe) {
                        //NS 1.22 sends this bizarre rubbish!
                        sdf = new SimpleDateFormat("EEEEE, dd-MMM-yy HH:mm:ss");
                        sdf.setLenient(true);
                        requestdate.setTime( sdf.parse(date) );
                    }

//                    if(filedate.before(requestdate)) {
                    if(requestdate.equals(filedate)) {  //if the file's last modified is before the request...
                        //If the file was modified before the request, send 304
                        // *** WRITE DATA ***
                        try {
                            rh.printDebugMessage(2, "Not sending file: "+f.getCanonicalPath()+" because it hasn't been modified.");
                            rh.setStatusCode(304);
                            rh.writeResponse();
                            rh.writeHeaders();
                        } catch (SocketException e) {
                            return;
                        } catch (IOException e) {
                            rh.dumpException(e);
                        }
                        return;
                    } //if filedate....
                }  //if date != null
            } catch (Exception e) {
                rh.dumpException(e);
            }
        } //if caching enabled...

        rh.setStatusCode(200);
        String mimeType = null;
        try {
            mimeType = vhcHostConf.getMimeDatabase().getMimeType(f);
        } catch (IOException e) {}

        if(mimeType != null)
            rh.addResponseHeader("Content-Type", mimeType);
        if(vhcHostConf.isBrowserCachingEnabled()) {
            rh.addResponseHeader("Last-Modified", f.getHttpLastModified());
        }
        rh.addResponseHeader("Content-Length", ""+f.length());

        try {
            rh.printDebugMessage(2, "Sending file: "+f.getCanonicalPath());
            rh.printDebugMessage(2, "Sending file as type: "+mimeType);
            rh.printDebugMessage(2, "Sending "+(f.length()+rh.getResponseHeaderSize())+" bytes...");

            rh.writeResponse();
            rh.writeHeaders();

            if(!rh.getCommand().toLowerCase().equals("head")) {
                //send contents...as binary...
                FileInputStream fis = new FileInputStream(f.getAbsolutePath());

                rh.writeStream(fis, f.length());
                fis.close();
            }
        } catch (SocketException e) {
            return; //prolly some dumb thing.
        } catch (IOException e) {
            rh.dumpException(e);
        }
    }

    private static void sendServerConfig(
        RequestHandler rh
    ) {
        rh.setStatusCode(200);
        String x = rh.getHttpdConf().getServerConfig();
        rh.addResponseHeader("Content-Length", Integer.toString(x.length()));
        rh.addResponseHeader("Content-Type", "text/html");

        // *** WRITE DATA ***
        try {
            rh.writeResponse();
            rh.writeHeaders();
            rh.writeString(x);
        } catch (SocketException ee) {
            return;
        } catch (IOException e) {
            rh.dumpException(e);
        }
    }

    private static void sendFolder(
        RequestHandler rh,
        SuperFile f,
        String sURI,
        Properties prArguments
    ) {
        /*  SENDING FOLDERS
            ===============

          First deal with default files
            - The easy way is to 302 it to the proper file...but then the
              browser records two locations.
            - Since directories work just as well as /index.html 's, why not just
              send the file if one is found?  Sure.

          Procedure:
            - If f is NOT a directory, then
                - Fail 500.
            - If there's a file called "index.html", or "index.htm" or "default.html" or "default.htm",
                - Send it and return.
            - If directory listings are disabled, then
                - Send 403.2.
        */
        VHostConf vhcHostConf = rh.getHostConf();

        if(!f.isDirectory()) {
            rh.signalError(500);
            return;
        }

        if(vhcHostConf.canLookForDefaultFiles()) {
            Enumeration enu = vhcHostConf.getDefaultFiles().elements();
            while(enu.hasMoreElements()) {
                SuperFile ff = new SuperFile(f, (String)enu.nextElement());
                if(ff.exists()) {
                    sendFile(rh, ff);
                    return;
                }
            }
        }

        if(!vhcHostConf.canListFolders()) {
            rh.signalError(403, 2, "");
            return;
        }

        try {
            rh.printDebugMessage(2, "Sending folder listing: "+f.getCanonicalPath());
        } catch (IOException e) {
            rh.dumpException(e);
        }

        StringBuffer sbOut = new StringBuffer();

        //Now, write the headers...

        sbOut.append("<TITLE>Directory Listing for "+sURI+"</TITLE>\r\n");
        sbOut.append("<LINK REL=STYLESHEET HREF=\"/$VFS:/style.css\">\r\n");
        sbOut.append("<BODY BGCOLOR=\"#FFFFFF\"><FONT FACE=\"Arial,Verdana\"><FONT SIZE=\"+2\">\r\n\r\n");

        sbOut.append("Directory Listing for "+sURI+"</FONT><BR>\r\n");
        sbOut.append("<BR>\r\n");

        if(vhcHostConf.canListFolderUsingTables()) {
            if(!sendTabledFolderListing(rh, f, sbOut, prArguments, sURI)) return;
        } else {
            if(!sendTextFolderListing(rh, f, sbOut, prArguments)) return;
        }

        rh.setStatusCode(200);
        rh.addResponseHeader("Content-Type", "text/html");
        rh.addResponseHeader("Content-Length", ""+sbOut.length());

        // *** WRITE DATA ***
        try {
            rh.writeResponse();
            rh.writeHeaders();
            rh.writeString(sbOut.toString());
        } catch (SocketException e) {
            return;
        } catch (IOException ee) {
            rh.dumpException(ee);
        }
    }

    private static boolean sendTextFolderListing(
        RequestHandler rh,
        SuperFile f,
        StringBuffer sbOut,
        Properties prArguments
    ) {
        VHostConf vhcHostConf = rh.getHostConf();
        int iDirs = 0;
        int iFiles = 0;
        long lSizes = 0;

        //get SuperFile data...
        SuperFile files[] = f.listSuperFiles();
        if(files == null) {
            rh.signalError(403);
            return false;
        }

        int iMaxSize[] = new int[5];
        MimeDatabase md = vhcHostConf.getMimeDatabase();

        iMaxSize[0] = RequestHelper.getBiggestStringLength(files, RequestHelper.SF_NAME, md)+2; //extra space for icon
        iMaxSize[1] = RequestHelper.getBiggestStringLength(files, RequestHelper.SF_SIZE, md)+2;
        iMaxSize[2] = RequestHelper.getBiggestStringLength(files, RequestHelper.SF_DATE, md)+2;
        iMaxSize[3] = RequestHelper.getBiggestStringLength(files, RequestHelper.SF_ATTR, md)+2;
        iMaxSize[4] = RequestHelper.getBiggestStringLength(files, RequestHelper.SF_MIME, md)+2;

        //read the argument.  if it makes any sense, then we'll act as appropriate
        String sorttype = prArguments.getProperty("sort", "null");

        RequestHelper.sortSuperFiles(
            files,
            RequestHelper.SF_NAME,
            vhcHostConf.isFileSystemCaseSensitive(),
            vhcHostConf.getMimeDatabase()
        );

        if(sorttype.equals("name") || sorttype.equals("null")) {iDirs = RequestHelper.SF_NAME;}
        else if (sorttype.equals("size")) {iDirs = RequestHelper.SF_SIZE;}
        else if (sorttype.equals("date")) {iDirs = RequestHelper.SF_DATE;}
        else if (sorttype.equals("attrib")) {iDirs = RequestHelper.SF_ATTR;}
        else if (sorttype.equals("mime")) {iDirs = RequestHelper.SF_MIME;}
        RequestHelper.sortSuperFiles(
            files,
            iDirs,
            vhcHostConf.isFileSystemCaseSensitive(),
            vhcHostConf.getMimeDatabase()
        );

        sbOut.append("<PRE><FONT FACE=\"Courier New,Courier,Fixed\">\r\n");

        writeTextHeader(rh, "name", "Name", iDirs, RequestHelper.SF_NAME, sbOut, iMaxSize, true);
        writeTextHeader(rh, "size", "Size", iDirs, RequestHelper.SF_SIZE, sbOut, iMaxSize, false);
        writeTextHeader(rh, "date", "Last Modified", iDirs, RequestHelper.SF_DATE, sbOut, iMaxSize, true);
        writeTextHeader(rh, "attrib", "Attr", iDirs, RequestHelper.SF_ATTR, sbOut, iMaxSize, true);
        writeTextHeader(rh, "mime", "MIME Type", iDirs, RequestHelper.SF_MIME, sbOut, iMaxSize, true);

        sbOut.append("\r\n");

        iDirs = 0;

      try {
        for(int i = 0;i < files.length; i++) {
            SuperFile childFile = files[i];
            if(childFile.isDirectory()) iDirs++; else iFiles++;
            lSizes += childFile.length();

            writeTextFileEntry(rh, childFile, md, sbOut, iMaxSize, vhcHostConf);
        }
      } catch (Exception e) {}
        sbOut.append("\r\n");
        String xx = SuperFile.getFileSize(iFiles)+" file(s) ";
        sbOut.append(RequestHelper.getPadding(xx, iMaxSize[0] + iMaxSize[1] + 1) + xx);
        sbOut.append(" " + SuperFile.getFileSize(lSizes)+" bytes.\r\n");

        xx = SuperFile.getFileSize(iDirs)+" folders(s) ";
        sbOut.append(RequestHelper.getPadding(xx, iMaxSize[0] + iMaxSize[1] + 1) + xx);
        if(iFiles > 0) sbOut.append(" " + SuperFile.getFileSize(lSizes/iFiles)+" avg. bytes / file.\r\n");

        sbOut.append("</FONT></PRE>\r\n");
        return true;
    }

    // A few utility functions for text listings
    private static void writeTextHeader(
        RequestHandler rh,
        String name,
        String descr,
        int type,
        int sort,
        StringBuffer sbOut,
        int iMaxSize[],
        boolean leftjustified
    ) {
        if(leftjustified) {
            if( (sort == RequestHelper.SF_NAME) && (rh.getHostConf().canShowIcons()) ) sbOut.append("  ");
            sbOut.append((type == sort?"<B>":"")+"<A HREF=\"?sort="+name+"\">");
            sbOut.append(descr+"</A>");
            sbOut.append(RequestHelper.getPadding(descr, iMaxSize[sort]));
            sbOut.append((type == sort?"</B>":""));
        } else {
            if( (sort == RequestHelper.SF_NAME) && (rh.getHostConf().canShowIcons()) ) sbOut.append("  ");
            sbOut.append(RequestHelper.getPadding(descr, iMaxSize[sort]-2));
            sbOut.append((type == sort?"<B>":"")+"<A HREF=\"?sort="+name+"\">");
            sbOut.append(descr+"</A>");
            sbOut.append((type == sort?"</B>  ":"  "));
        }
    }

    private static void writeTextFileEntry(
        RequestHandler rh,
        SuperFile childFile,
        MimeDatabase md,
        StringBuffer sbOut,
        int iMaxSize[],
        VHostConf vhcHostConf
    ) {
        boolean d = childFile.isDirectory();
        //Now work on populating names...
        sbOut.append("<A HREF=\"");
        sbOut.append(childFile.getName());
        if(d) sbOut.append("/");
        sbOut.append("\">");

        if(vhcHostConf.canShowIcons()) {
            sbOut.append("<IMG SRC=\"/$VFS:/");
            try {
                sbOut.append(md.getIcon(childFile));
            } catch (IOException e) {
                rh.dumpException(e);
            }
            sbOut.append("\" BORDER=0>");
        }

        sbOut.append(childFile.getName());
        sbOut.append("</A>");
        sbOut.append(RequestHelper.getPadding(childFile.getName(), iMaxSize[0]));

        //Now populate file sizes...
        if(!childFile.isDirectory()) {
            sbOut.append(RequestHelper.getPadding(childFile.getFileSize(), iMaxSize[1]-2) + childFile.getFileSize() + "  ");
        } else {
            sbOut.append(RequestHelper.getPadding("", iMaxSize[1]));
        }

        //Now populate last modified...
        sbOut.append( childFile.getLastModified() + RequestHelper.getPadding(childFile.getLastModified(), iMaxSize[2]) );

        //Now do file attributes
        sbOut.append( childFile.getAttrs() + RequestHelper.getPadding(childFile.getAttrs(), iMaxSize[3]) );

        //Finish MIME types!
        if(!childFile.isDirectory()) {
            String x = "";
            try {
                x = md.getMimeType(childFile);
            } catch (IOException e) {
                rh.dumpException(e);
            }
            sbOut.append( x + RequestHelper.getPadding(x, iMaxSize[4]) );
        } else {
            sbOut.append( "&lt;Directory&gt;" + RequestHelper.getPadding("<Directory>", iMaxSize[4]) );
        }
        sbOut.append("\r\n");
    }
    // end utility functions for text listings

    private static boolean sendTabledFolderListing(
        RequestHandler rh,
        SuperFile f,
        StringBuffer sbOut,
        Properties prArguments,
        String sLocalFile
    ) {
        VHostConf vhcHostConf = rh.getHostConf();
        int iDirs = 0;
        int iFiles = 0;
        long lSizes = 0;

        //get SuperFile data...
        SuperFile files[] = f.listSuperFiles();
        if(files == null) {
            rh.signalError(403);
            return false;
        }

        //read the argument.  if it makes any sense, then we'll act as appropriate
        String sorttype = prArguments.getProperty("sort", "null");

        //sort first by name (so that identical items are sorted by name)
        RequestHelper.sortSuperFiles(
            files,
            RequestHelper.SF_NAME,
            vhcHostConf.isFileSystemCaseSensitive(),
            vhcHostConf.getMimeDatabase()
        );

        if(sorttype.equals("name") || sorttype.equals("null")) {iDirs = RequestHelper.SF_NAME;}
        else if (sorttype.equals("size")) {iDirs = RequestHelper.SF_SIZE;}
        else if (sorttype.equals("date")) {iDirs = RequestHelper.SF_DATE;}
        else if (sorttype.equals("attrib")) {iDirs = RequestHelper.SF_ATTR;}
        else if (sorttype.equals("mime")) {iDirs = RequestHelper.SF_MIME;}

        RequestHelper.sortSuperFiles(
            files,
            iDirs,
            vhcHostConf.isFileSystemCaseSensitive(),
            vhcHostConf.getMimeDatabase()
        );

        if(vhcHostConf.canUseJavascriptInTableListings()) {
            sbOut.append("<SCRIPT><!--\r\n");
            sbOut.append("function DoComboBoxSelectionChanged(s) {\r\n");
            sbOut.append("    location.href = s.options[s.selectedIndex].text;\r\n");
            sbOut.append("}\r\n");
            sbOut.append("\r\n");
            sbOut.append("function mOvr(src,clrOver) {\r\n");
            sbOut.append("    if (!src.contains(event.fromElement)) {\r\n");
            sbOut.append("        src.style.cursor = 'hand';\r\n");
            sbOut.append("        src.bgColor = clrOver;\r\n");
            sbOut.append("    }\r\n");
            sbOut.append("}\r\n");
            sbOut.append("\r\n");
            sbOut.append("function mOut(src,clrIn) {\r\n");
            sbOut.append("    if (!src.contains(event.toElement)) {\r\n");
            sbOut.append("        src.style.cursor = 'default';\r\n");
            sbOut.append("        src.bgColor = clrIn;\r\n");
            sbOut.append("    }\r\n");
            sbOut.append("}\r\n");
            sbOut.append("\r\n");
            sbOut.append("function mClk(src) {\r\n");
            sbOut.append("    if(event.srcElement.tagName=='TD') {\r\n");
            sbOut.append("        location.href = \"?sort=\"+src\r\n");
            sbOut.append("    }\r\n");
            sbOut.append("}\r\n");
            sbOut.append("\r\n");
            sbOut.append("//--></SCRIPT>\r\n\r\n");
        }

        if(!canUseComboBoxForDirectoryNavigation(vhcHostConf)) {
            sbOut.append("http://<A HREF=\"/\">"+vhcHostConf.getHostName()+rh.getPortAsString()+"</A>/");

            String xx = "/";
            StringTokenizer st = new StringTokenizer(sLocalFile, "/");
            while(st.hasMoreTokens()) {
                String token = st.nextToken();
                xx += token;
                xx += "/";
                sbOut.append("<A HREF=\""+xx+"\">");
                sbOut.append(token);
                sbOut.append("</A>/");
            }
        } else {
            sbOut.append("<FORM>");
        }

        sbOut.append("<TABLE BORDER=0 WIDTH=100%>\r\n");

        if(canUseComboBoxForDirectoryNavigation(vhcHostConf)) {
            sbOut.append("<TR><TD COLSPAN=5 BGCOLOR=\"#00007F\">\r\n");
            sbOut.append(" <TABLE CELLPADDING=2 CELLSPACING=0 BORDER=0 WIDTH=100%><TR><TD><FONT FACE=Arial,Helvetica SIZE=-1><B>\r\n");
            sbOut.append("  <SELECT CLASS=\"control\" STYLE=\"width: 100%;\" WIDTH=100% onchange=\"DoComboBoxSelectionChanged(this);\">\r\n");

            String auf = "http://"+vhcHostConf.getHostName()+rh.getPortAsString()+"/";
            sbOut.append("  <OPTION>"+auf+"</OPTION>\r\n");

            StringTokenizer st = new StringTokenizer(sLocalFile, "/");
            while(st.hasMoreTokens()) {
                String token = st.nextToken();
                auf += token + "/";
                sbOut.append("  <OPTION "+(st.hasMoreTokens()?"":"SELECTED")+">"+auf+"</OPTION>\r\n");
            }
            sbOut.append("  </SELECT>\r\n");
            sbOut.append(" </TD></TR></TABLE>\r\n");
            sbOut.append("</TD></TR>\r\n");
        }

        sbOut.append("<TR>");

        writeTableHeader(rh, "name", "Name", RequestHelper.SF_NAME, iDirs, sbOut);
        writeTableHeader(rh, "size", "Size", RequestHelper.SF_SIZE, iDirs, sbOut);
        writeTableHeader(rh, "date", "Last Modified", RequestHelper.SF_DATE, iDirs, sbOut);
        writeTableHeader(rh, "attrib", "Attributes", RequestHelper.SF_ATTR, iDirs, sbOut);
        writeTableHeader(rh, "mime", "MIME Type", RequestHelper.SF_MIME, iDirs, sbOut);

        iDirs = 0;

        MimeDatabase md = vhcHostConf.getMimeDatabase();

        try {
            for(int i = 0;i < files.length; i++) {
                SuperFile childFile = files[i];
                if(childFile.isDirectory()) iDirs++; else iFiles++;
                lSizes += childFile.length();

                writeTableFileEntry(rh, childFile, sbOut, md);
            }
        } catch (Exception e) {}

        sbOut.append("<TR><TD COLSPAN=2 BGCOLOR=\"#336699\" ALIGN=RIGHT><FONT FACE=\"ARIAL\" COLOR=\"#FFFFFF\">"+SuperFile.getFileSize(iFiles)+" file(s)</TD>");
        sbOut.append("<TD COLSPAN=3 BGCOLOR=\"#336699\"><FONT FACE=\"ARIAL\" COLOR=\"#FFFFFF\">"+SuperFile.getFileSize(lSizes)+" bytes.</TD></TR>");
        sbOut.append("<TR><TD COLSPAN=2 BGCOLOR=\"#336699\" ALIGN=RIGHT><FONT FACE=\"ARIAL\" COLOR=\"#FFFFFF\">"+SuperFile.getFileSize(iDirs)+" folders(s)</TD>");
        if(iFiles > 0) sbOut.append("<TD COLSPAN=3 BGCOLOR=\"#336699\"><FONT FACE=\"ARIAL\" COLOR=\"#FFFFFF\">"+SuperFile.getFileSize(lSizes/iFiles)+" avg. bytes / file.</TD></TR>");
        sbOut.append("</TABLE>\n");

        if(canUseComboBoxForDirectoryNavigation(vhcHostConf)) {
            sbOut.append("</FORM>");
        }

        return true;
    }

    private static boolean canUseComboBoxForDirectoryNavigation(VHostConf vhcHostConf) {
        return (vhcHostConf.canUseJavascriptInTableListings()) && (vhcHostConf.canUseComboBoxForDirectoryNavigation());
    }

    // A few utility methods for tabled directory listings
    private static void writeTableHeader(
        RequestHandler rh,
        String name,
        String descr,
        int type,
        int sort,
        StringBuffer sbOut
    ) {
        VHostConf vhcHostConf = rh.getHostConf();
        sbOut.append("<TD BGCOLOR=\""+(sort == type?"#6699CC":"#336699")+"\"");
        if(vhcHostConf.canUseJavascriptInTableListings() && (sort != type)) {
            sbOut.append("onmouseover=\"mOvr(this,'#6699CC');\" onmouseout=\"mOut(this,'#336699');\" onclick=\"mClk('"+name+"');\"");
        }
        sbOut.append("><FONT FACE=\"ARIAL\" COLOR=\"#FFFFFF\">");
        if(sort == type)
            sbOut.append("<B>&lt;");
        else
            sbOut.append("<A CLASS=\"SortBar\" HREF=\"?sort="+name+"\">");

        sbOut.append(descr);
        if(sort == type)
            sbOut.append("&gt;</B>");
        else
            sbOut.append("</A>");
        sbOut.append("</TD>\r\n");
    }

    private static void writeTableFileEntry(
        RequestHandler rh,
        SuperFile childFile,
        StringBuffer sbOut,
        MimeDatabase md
    ) {
        VHostConf vhcHostConf = rh.getHostConf();
        boolean d = childFile.isDirectory();

        //Now work on populating names...
        sbOut.append("<TR><TD BGCOLOR=\"#EEEECC\"><FONT FACE=\"Arial\" SIZE=-1><B>");
        sbOut.append("<A HREF=\"");sbOut.append(childFile.getName());
        if(d) sbOut.append("/");
        sbOut.append("\">");

        if(vhcHostConf.canShowIcons()) {
            sbOut.append("<IMG SRC=\"/$VFS:/");
            try {
                sbOut.append(md.getIcon(childFile));
            } catch (IOException e) {
                rh.dumpException(e);
            }
            sbOut.append("\" BORDER=0>");
        }

        sbOut.append(childFile.getName());
        sbOut.append("</A></FONT></TD>");

        //Now populate file sizes...
        sbOut.append("<TD BGCOLOR=\"#EEEECC\" ALIGN=RIGHT><FONT FACE=\"Arial\" SIZE=-1><B>");
        if(d) sbOut.append("&nbsp;"); else sbOut.append( childFile.getFileSize() );
        sbOut.append("</TD>");

        //Now populate last modified...
        sbOut.append("<TD BGCOLOR=\"#EEEECC\"><FONT FACE=\"Arial\" SIZE=-1><B>");
        sbOut.append(childFile.getLastModified());
        sbOut.append("</TD>");

        //Now do file attributes
        sbOut.append("<TD BGCOLOR=\"#EEEECC\"><FONT FACE=\"Courier New\" SIZE=-1><B>");
        sbOut.append(childFile.getAttrs());
        sbOut.append("</TD>");

        //Finish MIME types!
        sbOut.append("<TD BGCOLOR=\"#EEEECC\"><FONT FACE=\"Arial\" SIZE=-1><B>");
        if(d) {
            sbOut.append("&lt;Directory&gt;");
        } else {
            try {
                sbOut.append(md.getMimeType(childFile));
            } catch (IOException e) {
                rh.dumpException(e);
            }
        }
        sbOut.append("</TD></TR>");
    }
    // end utility methods for tabled directory listings

    private static void handleCGIFile(
        RequestHandler rh,
        String sLocalFile,
        String sArguments
    ) {
        VHostConf vhcHostConf = rh.getHostConf();
        String sURI = sLocalFile;
        sLocalFile = sLocalFile.substring(8).replace('/', File.separatorChar);
        String sCgiProgram = vhcHostConf.getCgiRoot()+sLocalFile;

        rh.printDebugMessage(2, sCgiProgram);

        rh.printDebugMessage(2, "Entering CGI folder...");

        /*  SETTING UP CGI ENVIRONMENT
            ==========================
            The Runtime.exec() process takes an array of "key=value" strings.
            Following is a list of stuff that Apache feeds us:

            DOCUMENT_ROOT=/usr/apache/htdocs
            GATEWAY_INTERFACE=CGI/1.1
            HOSTTYPE=i386
            HTTP_ACCEPT=* /*
            HTTP_ACCEPT_ENCODING=gzip, deflate
            HTTP_ACCEPT_LANGUAGE=en-us
            HTTP_CONNECTION=Keep-Alive
            HTTP_HOST=thibs
            HTTP_USER_AGENT=Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)
            OSTYPE=Linux
            PATH=/usr/local/bin:/bin:/sbin:/usr/bin:/usr/sbin:/usr/games:/usr/local/sbin:/usr/X11R6/bin
            QUERY_STRING=
            REMOTE_ADDR=206.79.154.2
            REMOTE_PORT=57990
            REQUEST_METHOD=GET
            REQUEST_URI=/~bean/cgi-bin/moo.cgi
            SCRIPT_FILENAME=/home/bean/public_html/cgi-bin/moo.cgi
            SCRIPT_NAME=/~bean/cgi-bin/moo.cgi
            SERVER_ADMIN=root@thibs.menloschool.org
            SERVER_NAME=thibs.menloschool.org
            SERVER_PORT=80
            SERVER_PROTOCOL=HTTP/1.1
            SERVER_SIGNATURE=Apache/1.3.6 Server at thibs.menloschool.org Port 80
            SERVER_SOFTWARE=Apache/1.3.6 (Unix) PHP/3.0.7
            SHELL=/bin/sh
            SHLVL=1
            TERM=dumb
            _=/usr/bin/env
            */
        //Set up Properties to hold environment.  Will eventually convert to string array...somehow.
        Properties prEnv = new Properties();
        setProperty(prEnv,"DOCUMENT_ROOT", vhcHostConf.getDocumentRoot());
        setProperty(prEnv,"GATEWAY_INTERFACE", "CGI/1.1");
        if(System.getProperty("PATH") != null) {
            setProperty(prEnv,"PATH", System.getProperty("PATH"));
        }
        setProperty(prEnv,"QUERY_STRING", sArguments);
        InetAddress iaClient = rh.getRemoteAddr();
        setProperty(prEnv,"REMOTE_ADDR", iaClient.getHostAddress());
        setProperty(prEnv,"REMOTE_HOST", iaClient.getHostName());
        setProperty(prEnv,"REMOTE_PORT", Integer.toString(rh.getRemotePort()));
        setProperty(prEnv,"REQUEST_METHOD", "GET");
        setProperty(prEnv,"REQUEST_URI", '/'+sURI);
        setProperty(prEnv,"SCRIPT_FILENAME", sCgiProgram);
        setProperty(prEnv,"SCRIPT_NAME", '/'+sURI);
        setProperty(prEnv,"SERVER_NAME", vhcHostConf.getHostName());
        setProperty(prEnv,"SERVER_PORT", Integer.toString(rh.getHostPort()));
        setProperty(prEnv,"SERVER_PROTOCOL", "HTTP/1.0");
        setProperty(prEnv,"SERVER_SOFTWARE", httpdconf.sProdName);
        setProperty(prEnv,"SERVER_ADMIN", vhcHostConf.getWebAdminEmail());

        //Now, loop through the HTTP headers and put THEM in.
        Enumeration enu = rh.getRequestHeaderNamesEnumerator();
        String key, value;
        while(enu.hasMoreElements()) {
            key = (String)enu.nextElement();
            value = rh.getRequestHeaderValue(key);
            key = key.replace('-', '_').toUpperCase();
            setProperty(prEnv,"HTTP_"+key, value);
        }

        //Now make a string array for environment variables.
        String env[] = new String[prEnv.size()];
        enu = prEnv.propertyNames();
        for(int i=0;i<env.length;i++) {
            env[i] = (key = (String)enu.nextElement())+"="+prEnv.getProperty(key);
        }

        //Now run program
        try {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(sCgiProgram, env);
            } catch (IOException e) {
                rh.signalError(404, "/cgi-bin/"+sLocalFile);
                return;
            }
            InputStream in = p.getInputStream(); //really the program's output stream
//            OutputStream out = p.getOutputStream(); //really the program's input.
            int x;
            byte b[] = new byte[8192];

            OutputStream resp = rh.getWriteStream(); //really the response stream; hook it to "in".
//            InputStream req = rh.getReadStream(); //really the request stream; hook it from "out".

            DataInputStream disIn = new DataInputStream(in);
            String input = disIn.readLine();
            /*  DETERMINING RESPONSE CODES
                ==========================

                The first line is held in a variable named "input".
                If input starts with "HTTP/", then {
                    send response
                    jump to loop below.
                } else if input starts with "Status:", then {
                    read error code
                    set status code to whatever we read
                    signal "error" if not 200/304.
                    write "CGI data:"
                    jump to loop below.
                } else if input starts with Location: {
                    set status code 301
                    write status code
                    add input to headers
                    write headers
                    do NOT jump to loop below.
                } else if input starts with content-type: {
                    set status code 200
                    write status code
                    jump to loop below
                } else (we have some weird CGI problem? bug?) {
                    signal 500.
                }
            */

            if(input.toLowerCase().startsWith("http/")) {
                rh.writeString(input);
                rh.writeString(RequestHandler.crlf);
            } else if (input.toLowerCase().startsWith("status:")) {
                int temp = input.indexOf(":");
                rh.writeString("HTTP/1.0 ");
                rh.writeString(input.substring(temp+1));
                rh.writeString(RequestHandler.crlf);
            } else if (input.toLowerCase().startsWith("location:")) {
                rh.writeString("HTTP/1.0 302 Moved Temporarily\r\n");
                rh.writeString(input);
                rh.writeString(RequestHandler.crlf);
                return;
            } else if (input.toLowerCase().startsWith("content-type:")) {
                rh.setStatusCode(200);
                rh.writeResponse();
            } else {
                rh.signalError(500);
                return;
            }

            // "loop below"
            while(true) {
                //This is a GET, so we don't have a STDIN to worry about.
/*                x = req.available();
                if(x > 0) { //read input socket, dump it to program
                    x = req.read(b);
                    out.write(b, 0, x);
                }
*/
                x = in.available();
                if(x > 0) { //read input, dump it out the socket
                    x = in.read(b);
                    resp.write(b, 0, x);
                }

                try {
                    p.exitValue();
                    break;
                } catch (IllegalThreadStateException e) {}
                Thread.sleep(100);
            }
            long time = System.currentTimeMillis();
            while((System.currentTimeMillis() - time) < vhcHostConf.getCgiOutputAfterDeathTimeout()) {
                x = in.available();
                b = new byte[x];
                x = in.read(b);
                resp.write(b, 0, x);
            }
        } catch (Exception e) {rh.dumpException(e);}
    }

    private static Object setProperty(Properties p, String key, String value) {
        return p.put(key, value);
    }
}
