/*
 * window.c -- Window management routines.
 * Copyright (C) 2006 Darrick Wong
 */
#include <termios.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include "ugh.h"

static struct winsize wsize;

/* Initialize the window data */
int init_window(void)
{
	update_windata();
	return 1;
}

/* Update window data */
void update_windata(void)
{
	struct winsize sz;
	int x;

	x = ioctl(1, TIOCGWINSZ, &sz);
	if (x) {
		perror("stdout");
		return;
	}

	wsize = sz;
}

/* Return the window width */
unsigned short get_window_width(void)
{
	return wsize.ws_col;
}

/* Return the window height */
unsigned short get_window_height(void)
{
	return wsize.ws_row;
}
