/*
 * ugh.h -- Common stuff
 * Copyright (C) 2006 Darrick Wong
 */
#ifndef UGH_H
#define UGH_H

#include <stdint.h>

int init_uname(void);
int init_time(void);
int init_window(void);

void toggle_details(void);
int is_detailed(void);

void toggle_disk_units(void);
void toggle_net_units(void);

void process_cpus(void);
void process_uname(void);
void process_loadavg(void);
void process_meminfo(void);
void process_netdev(void);
void process_uptime(void);
void process_disk(void);
void process_irq(void);

double my_round(double x);
void update_windata(void);
unsigned short get_window_width(void);
unsigned short get_window_height(void);

void update_time(void);
uint64_t elapsed_time(void);

#define CLR_EOL	"\033[K"
#define CLEAR_SCR	"\033[2J"
#define ZERO_SCR	"\033[0;0H"

#endif
