package jrand;

import java.util.*;
import jrand.event.*;
import jrand.error.*;

public class CFGList {
	private Hashtable rules;
	private Vector ruleNameCache;
	private CFGNode rootnode;
	private String rootname;
	private Vector listeners;

	public CFGList() {
		rules = new Hashtable();
		ruleNameCache = new Vector();
		listeners = new Vector();
	}

	//handle the root
	public CFGNode getRootNode() {return rootnode;}
	public String getRootName() {return rootname;}
	public void setRootName(String name) {
		if(!rules.containsKey(name)) {
			System.err.println("Trying to set a non-member root!");
			return;
		}
		rootnode = getRule(name);
		rootname = name;

		ruleNameCache.removeElement(name);
		ruleNameCache.insertElementAt(name, 0);
		fireRootChanged(name);
	}
	
	public int getListSize() {return rules.size();}
	public String getRuleName(int where) {return (String)ruleNameCache.elementAt(where);}
	public CFGNode getRuleNode(int where) {
		String x = (String)ruleNameCache.elementAt(where);
		return getRule(x);
	}

	public CFGNode getRule(String name) {
		return (CFGNode)rules.get(name);
	}

	public void addRule(String name, CFGNode head) throws InvalidRuleNameException {
		validateRuleName(name);
		rules.put(name, head);
		ruleNameCache.addElement(name);
		fireIntervalAdded(name, ruleNameCache.size(), ruleNameCache.size());
	}
	public CFGNode deleteRule(String name) {
		CFGNode cn = getRule(name);
		rules.remove(name);
		int oldidx = ruleNameCache.indexOf(name);
		ruleNameCache.removeElement(name);
		fireIntervalDeleted(name, oldidx, oldidx);
		return cn;
	}
	public void renameRule(String oldname, String newname) throws InvalidRuleNameException {
		validateRuleName(newname);
		CFGNode cn = (CFGNode)rules.get(oldname);
		rules.put(newname, cn);
		rules.remove(oldname);
		int idx = ruleNameCache.indexOf(oldname);
		ruleNameCache.removeElement(oldname);
		ruleNameCache.insertElementAt(newname, idx);
		fireContentsChanged(oldname, idx, idx);
	}

	public Enumeration getRuleNames() {return rules.keys();}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		Enumeration k = ruleNameCache.elements();
		String key;
		CFGNode cn;

		sb.append("<"+getRootName()+"> = ");
		sb.append(getRootNode().toString());
		sb.append("\n");

		while(k.hasMoreElements()) {
			key = (String)k.nextElement();
			cn = getRule(key);
			if(cn == getRootNode()) continue;

			sb.append("<"+key+"> = ");

			sb.append(cn.toString());
			sb.append(" ");
			/*

			while(cn != null) {
				sb.append(cn.toString());
				sb.append(" ");
				cn = cn.getNext();
			}
			*/
			sb.append("\n");
		}
		return sb.toString();
	}
	

	public void addCFGListDataListener(CFGListDataListener ldl) {
		listeners.addElement(ldl);
	}

	public void removeCFGListDataListener(CFGListDataListener ldl) {
		listeners.removeElement(ldl);
	}

	public void fireIntervalAdded(Object source, int idx0, int idx1) {
		Enumeration e = listeners.elements();

		while(e.hasMoreElements()) {
			Object o = e.nextElement();
			if(o instanceof CFGListDataListener) {
				((CFGListDataListener)o).intervalAdded(new CFGListDataEvent(source, CFGListDataEvent.INTERVAL_ADDED, idx0, idx1));
			}
		}
	}
	
	public void fireIntervalDeleted(Object source, int idx0, int idx1) {
		Enumeration e = listeners.elements();

		while(e.hasMoreElements()) {
			Object o = e.nextElement();
			if(o instanceof CFGListDataListener) {
				((CFGListDataListener)o).intervalAdded(new CFGListDataEvent(source, CFGListDataEvent.INTERVAL_REMOVED, idx0, idx1));
			}
		}
	}

	public void fireContentsChanged(Object source, int idx0, int idx1) {
		Enumeration e = listeners.elements();

		while(e.hasMoreElements()) {
			Object o = e.nextElement();
			if(o instanceof CFGListDataListener) {
				((CFGListDataListener)o).intervalAdded(new CFGListDataEvent(source, CFGListDataEvent.CONTENTS_CHANGED, idx0, idx1));
			}
		}
	}

	public void fireRootChanged(Object source) {
		Enumeration e = listeners.elements();

		while(e.hasMoreElements()) {
			Object o = e.nextElement();
			if(o instanceof CFGListDataListener) {
				((CFGListDataListener)o).rootChanged(new CFGListDataEvent(source, CFGListDataEvent.ROOT_CHANGED, 0, 0));
			}
		}
	}

	public void validateRuleName(String name) throws InvalidRuleNameException {
		int len = name.length();

		for(int i = 0; i < len; i++) {
			char c = name.charAt(i);

			switch(c) {
				case ' ':
				case '<':
				case '>':
				case '\"':
				case '\'':
					throw new InvalidRuleNameException("The rule \""+name+"\" has an invalid character.");
			}
		}
	}
}
