import java.io.*;
import java.awt.*;
import java.applet.*;
import jrand.*;
import jrand.parser.*;
import java.net.*;

public class randapplet extends Applet implements Runnable {
	private TextArea ta;
	private TextAreaOutputStream taos;
	private OutputStream output;
	private PrintStream os;
	private Thread t;

	public void init() {
		try {
			ta = new TextArea("", 20, 80, TextArea.SCROLLBARS_VERTICAL_ONLY);
			ta.setEditable(false);
			ta.setBackground(Color.white);
			setLayout(new BorderLayout());
			add(ta, BorderLayout.CENTER);

			//output = System.out;
			output = new TextAreaOutputStream(ta);
			output = new HumanOutputStream(output);
			os = new PrintStream(output);

			t = new Thread(this);
			t.start();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public void run() {
		try {
			//now parse the grammar specification.
			InputStream is;
			try {
				is = getClass().getResourceAsStream(getParameter("grammarfile"));
				ta.append("Loading grammar: "+getParameter("grammarfile")+" from jar.\n\n");
			} catch (Exception e) {
				URL grammarurl = new URL(getDocumentBase(), getParameter("grammarfile"));
				ta.append("Loading grammar: "+grammarurl.toString()+"\n\n");
				is = grammarurl.openStream();
			}

			InputStreamReader grammar = new InputStreamReader(is);

			CFGParser cfp = new CFGParser(grammar);
			cfp.parse();
			CFGList cl = cfp.getList();

			grammar.close();
			is.close();

			while(true) {
				PrintRandomCFGNode(os, cl, cl.getRootNode());
				os.print("\n\n");
			}
		} catch (Exception e) {
			e.printStackTrace(os);
		}
	}

	private static int rand() {
		return (int)Math.round(Math.random() * 65536);
	}

	private void PrintRandomCFGNode(PrintStream out, CFGList list, CFGNode node) {
		if(node == null) return;
		CFGNode cn = node;
		
		while(cn != null) {
			switch(cn.getType()) {
				case CFGNode.UNRESOLVED:
					node.resolveNode(list);
					out.println("Serious error! Node "+cn.getUPointer()+" is not resolved!");
					if(cn.getType() == CFGNode.RESOLVED) {
						PrintRandomCFGNode(out, list, cn.getRPointer());
					}
					break;
				case CFGNode.RESOLVED:
					PrintRandomCFGNode(out, list, cn.getRPointer());
					break;
				case CFGNode.STRING:
					out.print(cn.getText());
					break;
				case CFGNode.COMBINATION:
					int p = rand() % cn.getPossibilityCount();

					PrintRandomCFGNode(out, list, cn.getPossibility(p));
					break;
				default:
					System.err.println("streamTest: Huh?  Unrecognized node type "+cn.getType()+".");
					break;
			}
			cn = cn.getNext();
		}
	}
}
