import java.io.*;
import jrand.*;
import jrand.parser.*;

public class randacfg {
	public static void main(String args[]) {
		//defaults
		String grammarfile = "default.cfg";
		int iterations = 1;
		boolean dumpGrammar = false;
		boolean is_human = false;
		boolean is_w4r3z_d00dz = false;
		boolean is_fun = false;
		
		//parse options
		int argc = args.length;

		try {

			for(int i = 0; i < argc; i++) {
				String arg = args[i];
				if(arg.equalsIgnoreCase("-f")) {
					grammarfile = args[i+1];
					i++;
				} else if(arg.equalsIgnoreCase("-n")) {
					iterations = Integer.parseInt(args[i+1]);
					i++;
				} else if(arg.equalsIgnoreCase("-i")) {
					iterations = -1;
				} else if(arg.equalsIgnoreCase("-d")) {
					dumpGrammar = true;
				} else if(arg.equalsIgnoreCase("-31337")) {
					is_w4r3z_d00dz = true;
				} else if(arg.equalsIgnoreCase("-h")) {
					is_human = true;
				} else if(arg.equalsIgnoreCase("-fun")) {
					is_fun = true;
				} else if(arg.equals("-?")) {
					sendHelp();
					System.exit(1);
				} else {
					System.err.println("randacfg: Argument "+arg+" not recognized.");
					sendHelp();
					System.exit(1);
				}
			}
			//now parse the grammar specification.
			Reader grammar = new FileReader(grammarfile);
			CFGParser cfp = new CFGParser(grammar);
			cfp.parse();
			CFGList cl = cfp.getList();

			OutputStream sysout = System.out;

			//did user want 31337 interface?
			if(is_w4r3z_d00dz) {
				sysout = new LeetOutputStream(sysout);
			}

			//did user want human interface?
			if(is_human) {
				sysout = new HumanOutputStream(sysout);
			}

			//did user ask for fun?
			if(is_fun) {
				sysout = new FunOutputStream(sysout);
			}

			//did user add any streams?
			if(!sysout.equals(System.out)) {
				sysout = new PrintStream(sysout);
				System.setOut((PrintStream)sysout);
			}
			
			//did user ask for grammar?
			if(dumpGrammar) {
				System.out.print(cl.toString());
				System.out.print("\n");
			}

			//now print stuff out.
			if(iterations < 0) {
				while(true) {
					PrintRandomCFGNode(cl, cl.getRootNode());
					System.out.print("\n\n");
				}
			} else {
				for(int x = 0; x < iterations; x++) {
					PrintRandomCFGNode(cl, cl.getRootNode());
					System.out.print("\n\n");
				}
			}			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	private static int rand() {
		return (int)Math.round(Math.random() * 65536);
	}

	private static void PrintRandomCFGNode(CFGList list, CFGNode node) {
		if(node == null) return;
		CFGNode cn = node;
		
		while(cn != null) {
			switch(cn.getType()) {
				case CFGNode.UNRESOLVED:
					node.resolveNode(list);
					System.err.println("Serious error! Node "+cn.getUPointer()+" is not resolved!");
					if(cn.getType() == CFGNode.RESOLVED) {
						PrintRandomCFGNode(list, cn.getRPointer());
					}
					break;
				case CFGNode.RESOLVED:
					PrintRandomCFGNode(list, cn.getRPointer());
					break;
				case CFGNode.STRING:
					System.out.print(cn.getText());
					break;
				case CFGNode.COMBINATION:
					int p = rand() % cn.getPossibilityCount();

					PrintRandomCFGNode(list, cn.getPossibility(p));
					break;
				default:
					System.err.println("streamTest: Huh?  Unrecognized node type "+cn.getType()+".");
					break;
			}
			cn = cn.getNext();
		}
	}

	private static void sendHelp() {
		System.out.print("jrand, version 0.35.  Copyright (C)2001 Darrick Wong.\n");
		System.out.print("Usage: java [-D...] randacfg [-n number | -i] [-h] [-31337] [-f file] [-d]\n");
		System.out.print("	-n number	Print out \"number\" sentences.\n");
		System.out.print("	-i		Print random sentences forever.\n");
		System.out.print("	-f file		Read grammar from \"file\".  Default is grammar.cfg.\n");
		System.out.print("	-d		Print out the grammar that was read in.\n");
		System.out.print("	-31337		Print out sentences l1k3 th1z.\n");
		System.out.print("	-h		Print out sentences at human speed.\n");
		System.out.print("	-fun		Print out sentences in wavy patterns.\n");
		System.out.print("\n");
		System.out.print("You may use -DHumanOutput.Params={x,y,z,a,b} to modify the parameters to the\n");
		System.out.print("human output printer.  x,y,a and b are all measured in seconds.  x is the pause\n");
		System.out.print("between characters, y is the pause between whitespace and punctuation, a is the\n");
		System.out.print("smallest pause and b is the largest pause.  z is a variability factor, with 0\n");
		System.out.print("being relatively invariable and infinity being very variable. Defaults:\n");
		System.out.print("{0.1, 0.3, 1.0, 0.08, 1.8}.\n");
	}
}
