import java.awt.*;
import BaseGraph;
import java.util.*;

public class TempGraph extends BaseGraph {
   public final int n = 256;

   public TempGraph (int idx, PropertyPanelScript pps, PropertyPanelManager pp, ConfigManager cfgmgr, DatabaseManager dbmgr, StatusBar sb, String unts, float inv, String c){
       super(idx, pps, pp, cfgmgr, dbmgr, sb, unts, inv, c);
       selectedColor = Color.magenta;
       curveColor = Color.black;
       labelColor = Color.black;
       yGranularity = 100;
       axisColor = Color.darkGray;
       locatorCaption = Color.black;
   }

   protected void paintBackground(Graphics2D g){
       GradientPaint gp = new GradientPaint(0,0, Color.yellow, 0, getSize().height, Color.red);
       g.setPaint(gp);
       g.fill(new Rectangle(0, 0, getSize().width, getSize().height));
   }

   protected void paintGrid(Graphics2D g){
       return;
   }
/*   public void setColorScheme(String s) {
       if(s.equals("Monochrome")){
           setBackground(Color.white);
           labelColor = Color.black;
           gridColor = new Color(208, 208, 208);
           locatorColor = Color.darkGray;
           locatorCaption = Color.black;
           axisColor = Color.black;
           selectedColor = Color.black;
           curveColor = Color.darkGray;
       } else { //this is "standard" scheme!
           setBackground(Color.black);
           labelColor = Color.black;
           gridColor = darkGreen;
           locatorColor = lightBlue;
           locatorCaption = Color.black;
           axisColor = Color.darkGray;
           selectedColor = Color.magenta;
           curveColor = Color.black;
       }
   }*/
}
