import java.util.StringTokenizer;
import java.util.*;

class TElement {
   int     ElementType;
   int     AtomicNumber;
   String  Symbol;//char  Symbol[4];
   String  Name;//[17];
   float   Mass;
   int     RelativeMass;
   int     Melting;

   int     Boiling;

   String  Valency;//[11];
   int     DateDiscovered;
   String  Discoverer;//[128];
   String  NameOrigin;//[128];
   String  Uses;//[128];
   String  ObtainedFrom;//[128];

   String  ElectronConfig;
   float   Electronegativity; //Pauling Electronegativity

   float   Density;
   float   Ionization;
   float   SpecificHeat;
   float   Vaporization;
   float   AtomicRadii;

   float   Frequency;
   String  HalfLife;

   int     ClassType;
   int     State;

   float   Sanderson; //sanderson electroneg (en for short)
   float   Rochow; //allred-Rochow en
   float   Mulliken; //Mulliken en
   float   Allen; //Allen en
   float   gperkg; //g of element per kg of human

   float   zeff_s1, //zeffs
           zeff_s2,
           zeff_p2,
           zeff_s3,
           zeff_p3,
           zeff_d3,
           zeff_s4,
           zeff_p4,
           zeff_d4,
           zeff_f4,
           zeff_s5,
           zeff_p5,
           zeff_d5,
           zeff_s6,
           zeff_p6,
           zeff_s7;
   float   affinity; //kJ/mol

   float   enthalpies[]; //enthalpy of ionization

   float   molar_volume;
   float   sound_velocity;
   float   ohms;
   String  abundances;
   String  hazards;

   float   UniverseByWeight, UniverseByAtom,
           SunByWeight, SunByAtom,
           MeteoritesByWeight, MeteoritesByAtom,
           CrustalRocksByWeight, CrustalRocksByAtom,
           SeaWaterByWeight, SeaWaterByAtom,
           StreamByWeight, StreamByAtom,
           HumanByWeight, HumanByAtom;

   float   CovalentRadius;
   String  CASRegistry, Crystal;
   float   AtomicVol, HVaporization,
           ThermConductivity, HFusion, PIonPotent,
           SIonPotent, TIonPotent;

   //Now we have functions to decode data...
   public static TElement decode(String input, int iNumTokens) throws Exception{
       StringTokenizer strtok = new StringTokenizer(input, "\t", false);
       TElement result = new TElement();

//       if(strtok.countTokens() != iNumTokens) { throw new Exception("Input file format error; there are "+strtok.countTokens()+
//           " tokens; there should be "+iNumTokens+"!");}

       result.AtomicNumber = Integer.parseInt(strtok.nextToken());
       result.Symbol = strtok.nextToken();
       result.Name = strtok.nextToken();

       result.ElementType = Integer.parseInt(strtok.nextToken());
       result.Mass = parseFloat(strtok.nextToken());
       result.RelativeMass = Integer.parseInt(strtok.nextToken());

       result.Melting = Integer.parseInt(strtok.nextToken());
       result.Boiling = Integer.parseInt(strtok.nextToken());
       result.Valency = strtok.nextToken();

       result.DateDiscovered = Integer.parseInt(strtok.nextToken());
       result.Discoverer = strtok.nextToken();
       result.NameOrigin = strtok.nextToken();

       result.Uses = strtok.nextToken();
       result.ObtainedFrom = strtok.nextToken();

       StringBuffer x = new StringBuffer(strtok.nextToken());
       if(x.charAt(0) == '"'){
           x.reverse();
           x.setLength(x.length()-1);
           x.reverse();
           x.setLength(x.length()-1);
       }
       result.ElectronConfig = x.toString();
       result.Electronegativity = parseFloat(strtok.nextToken());
       result.Density = parseFloat(strtok.nextToken());

       result.Ionization = parseFloat(strtok.nextToken());
       result.SpecificHeat = parseFloat(strtok.nextToken());
       result.Vaporization = parseFloat(strtok.nextToken());

       result.AtomicRadii = parseFloat(strtok.nextToken());

       result.Frequency = parseFloat(strtok.nextToken());
       x = new StringBuffer(strtok.nextToken());
       if(x.charAt(0) == '"'){
           x.reverse();
           x.setLength(x.length()-1);
           x.reverse();
           x.setLength(x.length()-1);
       }
       result.HalfLife = x.toString();
       result.ClassType = Integer.parseInt(strtok.nextToken());
       result.State = Integer.parseInt(strtok.nextToken());

       result.Sanderson = parseFloat(strtok.nextToken());
       result.Rochow    = parseFloat(strtok.nextToken());
       result.Mulliken  = parseFloat(strtok.nextToken());
       result.Allen     = parseFloat(strtok.nextToken());
       result.gperkg    = parseFloat(strtok.nextToken());

       result.zeff_s1 = parseFloat(strtok.nextToken());
       result.zeff_s2 = parseFloat(strtok.nextToken());
       result.zeff_p2 = parseFloat(strtok.nextToken());
       result.zeff_s3 = parseFloat(strtok.nextToken());
       result.zeff_p3 = parseFloat(strtok.nextToken());
       result.zeff_d3 = parseFloat(strtok.nextToken());
       result.zeff_s4 = parseFloat(strtok.nextToken());
       result.zeff_p4 = parseFloat(strtok.nextToken());
       result.zeff_d4 = parseFloat(strtok.nextToken());
       result.zeff_f4 = parseFloat(strtok.nextToken());
       result.zeff_s5 = parseFloat(strtok.nextToken());
       result.zeff_p5 = parseFloat(strtok.nextToken());
       result.zeff_d5 = parseFloat(strtok.nextToken());
       result.zeff_s6 = parseFloat(strtok.nextToken());
       result.zeff_p6 = parseFloat(strtok.nextToken());
       result.zeff_s7 = parseFloat(strtok.nextToken());

       result.affinity = parseFloat(strtok.nextToken());

       result.molar_volume = parseFloat(strtok.nextToken());
       result.sound_velocity = parseFloat(strtok.nextToken());
       result.ohms = parseFloat(strtok.nextToken());
       result.abundances = strtok.nextToken();
       result.hazards = strtok.nextToken();

       result.UniverseByWeight = parseFloat(strtok.nextToken());
       result.UniverseByAtom = parseFloat(strtok.nextToken());
       result.SunByWeight = parseFloat(strtok.nextToken());
       result.SunByAtom = parseFloat(strtok.nextToken());
       result.MeteoritesByWeight = parseFloat(strtok.nextToken());
       result.MeteoritesByAtom = parseFloat(strtok.nextToken());
       result.CrustalRocksByWeight = parseFloat(strtok.nextToken());
       result.CrustalRocksByAtom = parseFloat(strtok.nextToken());
       result.SeaWaterByWeight = parseFloat(strtok.nextToken());
       result.SeaWaterByAtom = parseFloat(strtok.nextToken());
       result.StreamByWeight = parseFloat(strtok.nextToken());
       result.StreamByAtom = parseFloat(strtok.nextToken());
       result.HumanByWeight = parseFloat(strtok.nextToken());
       result.HumanByAtom = parseFloat(strtok.nextToken());

       result.CovalentRadius = parseFloat(strtok.nextToken());
       result.CASRegistry = strtok.nextToken().substring(1);
       result.Crystal = strtok.nextToken();
       result.AtomicVol = parseFloat(strtok.nextToken());
       result.HVaporization = parseFloat(strtok.nextToken());
       result.ThermConductivity = parseFloat(strtok.nextToken());
       result.HFusion = parseFloat(strtok.nextToken());
       result.PIonPotent = parseFloat(strtok.nextToken());
       result.SIonPotent = parseFloat(strtok.nextToken());
       result.TIonPotent = parseFloat(strtok.nextToken());

       return result;
   }

   private static float parseFloat(String s) {return FloatingNumber.readJavaFormatString(s).floatValue();}

   public static String getZeff(int number, Map elements) {
       TElement e = (TElement)elements.get(new Integer(number));
       return getZeff(e);
   }

   public static String getZeff(TElement currSelection) {
       StringBuffer sb = new StringBuffer();

       sb.append("Zeff for 1s:\t\t"+( currSelection.zeff_s1==-1.0?"Unknown":Float.toString(currSelection.zeff_s1) )+"\r\n");
       sb.append("Zeff for 2s:\t\t"+( currSelection.zeff_s2==-1.0?"Unknown":Float.toString(currSelection.zeff_s2) )+"\r\n");
       sb.append("Zeff for 2p:\t\t"+( currSelection.zeff_p2==-1.0?"Unknown":Float.toString(currSelection.zeff_p2) )+"\r\n");
       sb.append("Zeff for 3s:\t\t"+( currSelection.zeff_s3==-1.0?"Unknown":Float.toString(currSelection.zeff_s3) )+"\r\n");
       sb.append("Zeff for 3p:\t\t"+( currSelection.zeff_p3==-1.0?"Unknown":Float.toString(currSelection.zeff_p3) )+"\r\n");
       sb.append("Zeff for 3d:\t\t"+( currSelection.zeff_d3==-1.0?"Unknown":Float.toString(currSelection.zeff_d3) )+"\r\n");
       sb.append("Zeff for 4s:\t\t"+( currSelection.zeff_s4==-1.0?"Unknown":Float.toString(currSelection.zeff_s4) )+"\r\n");
       sb.append("Zeff for 4p:\t\t"+( currSelection.zeff_p4==-1.0?"Unknown":Float.toString(currSelection.zeff_p4) )+"\r\n");
       sb.append("Zeff for 4d:\t\t"+( currSelection.zeff_d4==-1.0?"Unknown":Float.toString(currSelection.zeff_d4) )+"\r\n");
       sb.append("Zeff for 4f:\t\t"+( currSelection.zeff_f4==-1.0?"Unknown":Float.toString(currSelection.zeff_f4) )+"\r\n");
       sb.append("Zeff for 5s:\t\t"+( currSelection.zeff_s5==-1.0?"Unknown":Float.toString(currSelection.zeff_s5) )+"\r\n");
       sb.append("Zeff for 5p:\t\t"+( currSelection.zeff_p5==-1.0?"Unknown":Float.toString(currSelection.zeff_p5) )+"\r\n");
       sb.append("Zeff for 5d:\t\t"+( currSelection.zeff_d5==-1.0?"Unknown":Float.toString(currSelection.zeff_d5) )+"\r\n");
       sb.append("Zeff for 6s:\t\t"+( currSelection.zeff_s6==-1.0?"Unknown":Float.toString(currSelection.zeff_s6) )+"\r\n");
       sb.append("Zeff for 6p:\t\t"+( currSelection.zeff_p6==-1.0?"Unknown":Float.toString(currSelection.zeff_p6) )+"\r\n");
       sb.append("Zeff for 7s:\t\t"+( currSelection.zeff_s7==-1.0?"Unknown":Float.toString(currSelection.zeff_s7) )+"\r\n");

       return sb.toString();
   }

};
