import javax.swing.*;
import java.awt.*;

class TextLoadStatusManager extends JDialog implements LoadStatusManager {
   private static final String text = "Loading JPeriod99...";
	private JLabel lProgress = new JLabel("Loading components...", SwingConstants.CENTER);

	public TextLoadStatusManager() {
   	this(text);
   }

	public TextLoadStatusManager(String t) {
  		this(new JFrame(), t, text);
   }

	public TextLoadStatusManager(Frame parent, String title, String lx) {
   	super(parent, title);
       setResizable(false);

       JLabel l;

       if(VerInfo.isJava3D())
       	l = new JLabel(lx +"with Java3D!", SwingConstants.CENTER);
       else
       	l = new JLabel(lx, SwingConstants.CENTER);

       Container c = getContentPane();

       c.setLayout(new GridLayout(2, 1));
       c.add(l);
       c.add(lProgress);

       //resize
       Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       setSize(d.width / 3, d.height / 6);

       Dimension b = getSize();
       setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);

       l.invalidate();
       lProgress.invalidate();
       validate();
   }

   public void setProgress(String s) {
       setVisible(true);
       doLayout();
       lProgress.setText(s);
       lProgress.invalidate();
       validate();
       repaint();
   }

   public String getProgress() {
   	return lProgress.getText();
   }

   public void setMaximum(int n) {}
   public int getMaximum() {return 0;}
   public void setProgressNum(int i) {}
   public int getProgressNum() {return 0;}
   public void setProgressText(String s) {setProgress(s);}

   public String getProgressText() {return getProgress();}

   public void setProgress(String s, int i) {
       setProgress(s);
   }

   public void setVisible(boolean b) {super.setVisible(b);}
   public void dispose() {super.dispose();}   
}
