import javax.swing.*;
import java.util.*;
import java.awt.*;
import javax.swing.border.*;

public class StatusBar extends JPanel {
   private JLabel sText = new JLabel("");
   private Vector icons = new Vector();

   public StatusBar() {this(null, null, null, null);}
   public StatusBar(String def) {this(def, null, null, null);}

   public StatusBar(String def, Icon icoBtns[], String strBtns[], boolean show[]) {
       GridBagLayout gridbag = new GridBagLayout();
       GridBagConstraints c = new GridBagConstraints();
       setLayout(gridbag);

       if(def != null) sText.setText(def);

       c.fill = GridBagConstraints.HORIZONTAL;
       c.weightx = 1.0;
       sText.setBorder(new SoftBevelBorder(BevelBorder.LOWERED));
       gridbag.setConstraints(sText, c);
       add(sText);

       if((icoBtns == null) || (strBtns == null)) return;

       for(int i = 0; i < icoBtns.length; i++) {
           JLabel x;
           try {
               x = new JLabel(icoBtns[i]);
           } catch (Exception ex) {ex.printStackTrace(); x = new JLabel(strBtns[i]);}
           x.setBorder(new SoftBevelBorder(BevelBorder.LOWERED));
     	    c.fill = GridBagConstraints.NONE; //end row
           c.weightx = 0.0;
           gridbag.setConstraints(x, c);
           icons.addElement(x);
           add(x);
           setIconVisibility(i, show[i]);
       }
   }

   public String getText() {return sText.getText();}
   public void setText(String s) {sText.setText(s);}

   public void setIconVisibility(int icon, boolean visible) {
       JLabel l = (JLabel)icons.elementAt(icon);
       l.setVisible(visible);
       doLayout();
   }
   public void toggleIconVisibility(int icon) {
       JLabel l = (JLabel)icons.elementAt(icon);
       l.setVisible(!l.isVisible());
       doLayout();
   }
}