class PropertyPanelScript {
   public static final String text = "Text";
   public static final String html = "HTML";
   public static final String table = "Table";
   public static final String panels = "Panels";
   public static final String graph = "Graph";

   public void run(
       LoadStatusManager lsmgr,
       PropertyPanelManager ppmgr,
       DatabaseManager dbmgr,
       ConfigManager cfgmgr,
       StatusBar sb
   ) {
       //first add tree nodes...
       lsmgr.setProgress("Adding tree nodes...");
       ppmgr.addRootNode(text);
       ppmgr.addRootNode(html);
       ppmgr.addRootNode(table);
       ppmgr.addRootNode(panels);
       ppmgr.addRootNode(graph);

       lsmgr.setProgress("Adding table of all properties...");
       AllElementInfo aei = new AllElementInfo(ppmgr, dbmgr, cfgmgr);
       ppmgr.addDefaultPropertyPanel(PropertyPanelManager.root, aei, aei);

       lsmgr.setProgress("Creating text property panels...");
       TextPanel tp;

       tp = new TextPanel(this, 0, "Electron Config", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       tp = new TextPanel(this, 1, "Half Life", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       tp = new TextPanel(this, 2, "Hazards:", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       tp = new TextPanel(this, 3, "Element Abundances:", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       tp = new TextPanel(this, 4, "CAS Registry Number", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       tp = new TextPanel(this, 5, "Crystal Structure", ppmgr, cfgmgr);
       ppmgr.addPropertyPanel(text, tp, tp);

       lsmgr.setProgress("Creating HTML property panels...");
       HTMLPanel hp = new HTMLPanel(this, 0, cfgmgr, "Element Info");
       ppmgr.addPropertyPanel(html, hp, hp);

       lsmgr.setProgress("Creating table property panels...");
       IonEnthalpy ie = new IonEnthalpy(cfgmgr, ppmgr);
       ppmgr.addPropertyPanel(table, ie, ie);

       Zeff zeff = new Zeff(cfgmgr, ppmgr);
       ppmgr.addPropertyPanel(table, zeff, zeff);

       lsmgr.setProgress("Creating panels...");
       AtomAni aa = new AtomAni();
       ppmgr.addPropertyPanel(panels, aa, aa);

       BodyMeasurement bm = new BodyMeasurement();
       ppmgr.addPropertyPanel(panels, bm, bm);

      lsmgr.setProgress("Creating graphs...");
       int g = 0;
       BaseGraph
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "amu", 0, "Atomic Mass");
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new TempGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "K", -1, "Melting Point");
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new TempGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "K", -1, "Boiling Point");
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "(g/cm^3)", -1, "Density");
       bg.yGranularity = 1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "(cal / gK)", -1, "Specific Heat");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 5 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "eV", -1, "Ionization Energy");
       bg.yGranularity = 1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "(Kcal / g*atom)", -1, "Vaporization Energy");
       bg.yGranularity = 10;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "Angstroms", -1, "Atomic Radius");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "MHz", -1, "Atomic Frequency at 2.344T");
       bg.yGranularity = 5;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Pauling Electronegativity");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 10 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Sanderson Electronegativity");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Rochow Electronegativity");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Mulliken Electronegativity");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Allen Electronegativity");
       bg.yGranularity = (float)0.1;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "g/kg", -1, "Element mass vs. body mass");
       bg.yGranularity = 10;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 15 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "kJ/mol", -1, "Electron Affinity");
       bg.yGranularity = 10;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "cm^3", -1, "Molar Volume");
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "m/s", -1, "Sound Velocity");
       bg.yGranularity = 500;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "u-ohms", -1, "Resistance");
       bg.yGranularity = 1000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Universe");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 20 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Universe");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Sun");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Sun");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Meteors");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Meteors");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 25 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Crustal Rocks");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Crustal Rocks");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Sea Water");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Sea Water");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Streams");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 30 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Streams");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Weight in Humans");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "ppb", -1, "Atoms in Humans");
       bg.yGranularity = 10000000;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "", -1, "Covalent Radius");
       bg.yGranularity = 0.1f;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "cm/mol", -1, "Atomic Volume");
       bg.yGranularity = 5.0f;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 35 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "kJ/mol", -1, "Heat of Vaporization");
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "W/cmK", -1, "Thermal Conductivity");
       bg.yGranularity = 0.5f;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "kJ/mol", -1, "Heat of Fusion");
       bg.yGranularity = 2.5f;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "W/cmK", -1, "1st Ionization Potential");
       bg.yGranularity = 1f;
       ppmgr.addPropertyPanel(graph, bg, bg);

       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "W/cmK", -1, "2nd Ionization Potential");
       bg.yGranularity = 5f;
       ppmgr.addPropertyPanel(graph, bg, bg);

      lsmgr.setProgress("Created 40 graphs...");
       bg = new BaseGraph(g++, this, ppmgr, cfgmgr, dbmgr, sb, "W/cmK", -1, "3rd Ionization Potential");
       ppmgr.addPropertyPanel(graph, bg, bg);

       lsmgr.setProgress("Selecting Hydrogen...");
       ppmgr.setAtom(1);
   }

   public float getGraphData(int index, TElement element) {
       switch(index) {
           case  0: return element.Mass;
           case  1: return element.Melting;
           case  2: return element.Boiling;
           case  3: return element.Density;
           case  4: return element.SpecificHeat;
           case  5: return element.Ionization;
           case  6: return element.Vaporization;
           case  7: return element.AtomicRadii;
           case  8: return element.Frequency;
           case  9: return element.Electronegativity;
           case 10: return element.Sanderson;
           case 11: return element.Rochow;
           case 12: return element.Mulliken;
           case 13: return element.Allen;
           case 14: return element.gperkg;
           case 15: return element.affinity;
           case 16: return element.molar_volume;
           case 17: return element.sound_velocity;
           case 18: return element.ohms;
           case 19: return element.UniverseByWeight;
           case 20: return element.UniverseByAtom;
           case 21: return element.SunByWeight;
           case 22: return element.SunByAtom;
           case 23: return element.MeteoritesByWeight;
           case 24: return element.MeteoritesByAtom;
           case 25: return element.CrustalRocksByWeight;
           case 26: return element.CrustalRocksByAtom;
           case 27: return element.SeaWaterByWeight;
           case 28: return element.SeaWaterByAtom;
           case 29: return element.StreamByWeight;
           case 30: return element.SeaWaterByAtom;
           case 31: return element.HumanByWeight;
           case 32: return element.HumanByAtom;
           case 33: return element.CovalentRadius;
           case 34: return element.AtomicVol;
           case 35: return element.HVaporization;
           case 36: return element.ThermConductivity;
           case 37: return element.HFusion;
           case 38: return element.PIonPotent;
           case 39: return element.SIonPotent;
           case 40: return element.TIonPotent;
       }
       throw new IllegalArgumentException("PropertyPanelScript.getGraphData: index is not within the range 0-9!");
   }

   public String getTextPanelData(int index, TElement element) {
       switch(index) {
           case 0: return element.ElectronConfig;
           case 1: return element.HalfLife;
           case 2: return element.hazards;
           case 3: return element.abundances;
           case 4: return element.CASRegistry;
           case 5: return element.Crystal;
       }
       throw new IllegalArgumentException("PropertyPanelScript.getTextPanelData: index is not within the range 0-5!");
   }

   public String getHtmlPanelData(int index, TElement element) {
       switch(index) {
           case 0: return "NameInfo/"+element.Name+".html";
       }
       throw new IllegalArgumentException("PropertyPanelScript.getHtmlPanelData: index is not within the range 0-0!");
   }
}
