import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import javax.swing.*;
import javax.swing.table.*;

public class IonEnthalpy extends JScrollPane implements IPanelListener, ActionListener {
   private PropertyPanelManager ppmgr;
   private JTable j = new JTable();

   private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 'C');
   private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 'P');
   private JMenu pmContext = new JCoolMenu("Panel");

   public String toString() {return "Ionization Enthalpies";}

   public IonEnthalpy(ConfigManager cfgmgr, PropertyPanelManager pp) {
       super();

       ppmgr = pp;

       Font f = j.getFont();
       j.setFont(new Font(f.getName(), 0, 20));
       j.setRowHeight(j.getRowHeight()+10);
       j.setSelectionMode(0);
       j.setCellSelectionEnabled(false);
       setViewportView(j);

       if(cfgmgr.canGetClipboard()) {
           miCopyToClipboard.addActionListener(this);
           miCopyToClipboard.setActionCommand("CopyToClipboard");
           pmContext.add(miCopyToClipboard);
       }

       if(cfgmgr.canPrint()) {
           miPrintGraph.addActionListener(this);
           miPrintGraph.setActionCommand("FilePrintText");
           pmContext.add(miPrintGraph);
       }
       pmContext.setMnemonic('P');
   }

   public void setAtom(PanelEvent pe) {
       TElement t = pe.getElement();
       float enthalpies[] = t.enthalpies;
       String columns[] = {"Electron", "Enthalpy (kJ/mol)"};

       DefaultTableModel dtm = new DefaultTableModel(columns, 0) {
           public boolean isCellEditable(int row, int col) {return false;}
       };

       for(int i = 0; i < enthalpies.length; i++){
           Object data[] = {new Integer(i), new Float(enthalpies[i])};
           dtm.addRow(data);
       }
       j.setModel(dtm);
       j.repaint();
   }

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();
       if(s.equals("CopyToClipboard")) {
           OnCopyToClipboard();
       } else if (s.equals("FilePrintText")) {
       	OnFilePrintText();
       }
   }
   private void OnCopyToClipboard() {
       StringBuffer sb = new StringBuffer();

       int rmax = j.getRowCount();
       int cmax = j.getColumnCount();

       for(int c=0;c<cmax;c++)
           sb.append( j.getColumnName(c) );
           
       sb.append("\r\n");

       for(int r=0;r<rmax;r++){
           for(int c=0;c<cmax;c++) {
               sb.append( (   (Object)j.getValueAt(r,c)   ).toString() );
               sb.append("\t");
           }
           sb.append("\r\n");
       }

       StringSelection ss = new StringSelection(sb.toString());
       Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
       c.setContents(ss, ss);
   }

   public void onActivate(PanelEvent pe) {
       ppmgr.addMenu(pmContext);
   }
   public void onDeactivate(PanelEvent pe) {
       ppmgr.removeMenu(pmContext);
   }

   private void OnFilePrintText() {
//       ItemPrinter ip = new ItemPrinter(this);
   }

   public void setStyle(PanelEvent pe) {}

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
