import javax.swing.*;
import java.io.IOException;
import java.net.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class HTMLPanel extends JScrollPane implements Runnable, IPanelListener {
   private JEditorPane ep = new JEditorPane();
   private String sCaption;
   private TElement theElement = null;
   private PropertyPanelScript script;
   private String sCodeBase;
   private int index;

   public String toString() {return sCaption;}

   public HTMLPanel(PropertyPanelScript s, int idx, ConfigManager cfgmgr, String sc) {
       sCaption = sc;
       script = s;
       index = idx;
       sCodeBase = cfgmgr.getCodeBase();

       if(cfgmgr.isApp()) {
           StringTokenizer st = new StringTokenizer(System.getProperty("user.dir"), "\\");
           String x = "";
           while (st.hasMoreTokens()) {
               x += st.nextToken() + "/";
           }
           sCodeBase = "file:/"+x;
       }
       ep.setEditorKitForContentType("content/unknown", ep.getEditorKitForContentType("text/html"));
       ep.setEditable(false);
       setViewportView(ep);
   }

   public void run() {
       if(theElement == null) return;

       try {
           URL earl = new URL(sCodeBase + script.getHtmlPanelData(index, theElement));
           ep.setPage(earl);
       } catch (IOException e) {;}
       catch (IllegalArgumentException e) {;}
       theElement = null;
   }

   public void setAtom(PanelEvent pe) {
       theElement = pe.getElement();
       Thread t = new Thread(this);
       t.start();
   }

   public void onActivate(PanelEvent pe) {}
   public void onDeactivate(PanelEvent pe) {}

   public void setStyle(PanelEvent pe) {}
}
