/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;

class ConfigManager {
    private boolean app;
    private String codeBase;
    private boolean writableFS = false;
    private boolean printable = false;
    private boolean exitVM = false;
    private boolean clipboard = false;
    private Applet applet;

    public ConfigManager(boolean bl, String string, Applet applet) {
        SecurityManager securityManager;
        this.app = bl;
        this.codeBase = string;
        this.applet = applet;
        try {
            securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkWrite("*.*");
            }
            this.writableFS = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkExit(0);
            }
            this.exitVM = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSystemClipboardAccess();
            }
            this.clipboard = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public boolean isApp() {
        return this.app;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public boolean canWriteFiles() {
        return this.writableFS;
    }

    public boolean canPrint() {
        return this.printable;
    }

    public boolean canExitVM() {
        return this.exitVM;
    }

    public boolean canGetClipboard() {
        return this.clipboard;
    }

    public final String getCrlf() {
        return System.getProperty("line.separator");
    }

    public Image getImage(String string) {
        try {
            if (this.app) {
                return Toolkit.getDefaultToolkit().getImage(string);
            }
            return this.applet.getImage(new URL(string));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

