/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class BaseGraph
extends JComponent
implements IPanelListener,
ActionListener,
MouseListener,
MouseMotionListener {
    public static final Color darkGreen = new Color(0, 48, 0);
    public static final Color lightGreen = new Color(0, 255, 0);
    public static final Color lightBlue = new Color(0, 0, 255);
    private PropertyPanelScript script;
    private PropertyPanelManager ppmgr;
    private Map elements;
    private int index;
    private StatusBar sbb;
    private int minElement = Integer.MAX_VALUE;
    private int maxElement = Integer.MIN_VALUE;
    private float stepX = 1.0f;
    private float minY = Float.MAX_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float stepY = 1.0f;
    private int selectedAtom = -1;
    private String units;
    private int X = 0;
    private int Y = 0;
    private float gridX = 0.0f;
    private float gridY = 0.0f;
    public Color labelColor = Color.white;
    public float invalid = 0.0f;
    public Color gridColor = darkGreen;
    public Color locatorColor = lightBlue;
    public float yGranularity = 10.0f;
    public Color axisColor = Color.white;
    public Color selectedColor = Color.red;
    public Color curveColor = lightGreen;
    public int yLowerMargin = 30;
    public int xLeftMargin = 50;
    public int yCaptionGranularity = 5;
    public int xCaptionGranularity = 10;
    public int yTopMargin = 10;
    public Color locatorCaption = Color.black;
    public int yCaptionLength = 5;
    private Dimension oldD = new Dimension(0, 0);
    private boolean bInterpolateMissing = false;
    private boolean bDrawLocator = true;
    private boolean bLocatorFollowCurve = true;
    private boolean bOpaqueCoords = true;
    private boolean activated = false;
    private JMenuItem miSaveGraphToFile = new JMenuItem("Save Graph Image...", 83);
    private JMenuItem miPrintGraph = new JMenuItem("Print Graph Image...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");
    private boolean mustRepaint = false;
    private String caption = "";
    private static int biw;
    private static int bih;
    private static BufferedImage iBuffer;
    private static BufferedImage iBack;
    private boolean fontInited = false;
    private MouseEvent emm = null;

    public int getMinElement() {
        return this.minElement;
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public BaseGraph(int n, PropertyPanelScript propertyPanelScript, PropertyPanelManager propertyPanelManager, ConfigManager configManager, DatabaseManager databaseManager, StatusBar statusBar, String string, float f, String string2) {
        this.caption = string2;
        this.invalid = f;
        this.units = string;
        this.script = propertyPanelScript;
        this.ppmgr = propertyPanelManager;
        this.elements = databaseManager.getElements();
        this.index = n;
        this.sbb = statusBar;
        Iterator iterator = this.elements.values().iterator();
        while (iterator.hasNext()) {
            float f2;
            TElement tElement = (TElement)iterator.next();
            int n2 = tElement.AtomicNumber;
            if (n2 < this.minElement) {
                this.minElement = n2;
            }
            if (n2 > this.maxElement) {
                this.maxElement = n2;
            }
            if ((f2 = this.script.getGraphData(this.index, tElement)) == this.invalid) continue;
            if (f2 < this.minY) {
                this.minY = f2;
            }
            if (!(f2 > this.maxY)) continue;
            this.maxY = f2;
        }
        this.setBackground(Color.black);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        if (configManager.canWriteFiles()) {
            this.miSaveGraphToFile.addActionListener(this);
            this.miSaveGraphToFile.setActionCommand("FileSaveGraph");
            this.pmContext.add(this.miSaveGraphToFile);
        }
        if (configManager.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintGraph");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        this.selectedAtom = panelEvent.getElement().AtomicNumber;
        this.mustRepaint = true;
        if (!this.activated) {
            return;
        }
        this.repaint();
    }

    protected void paintBackground(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    protected void paintGrid(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = this.yLowerMargin;
        graphics2D.setColor(this.gridColor);
        for (float f3 = this.minY; f3 < this.maxY; f3 += this.yGranularity) {
            f2 = (this.maxY - f3) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            graphics2D.drawLine(this.xLeftMargin - 15, Math.round(f2), dimension.width, Math.round(f2));
        }
        for (int i = this.minElement; i <= this.maxElement; ++i) {
            graphics2D.drawLine(Math.round(f), 0, Math.round(f), dimension.height - (this.yLowerMargin - 15));
            f += this.stepX;
        }
    }

    protected void paintXAxis(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = this.yLowerMargin;
        graphics2D.setColor(this.axisColor);
        graphics2D.drawLine(this.xLeftMargin - 15, dimension.height - (this.yLowerMargin - 15), dimension.width, dimension.height - (this.yLowerMargin - 15));
        for (int i = this.minElement; i <= this.maxElement; ++i) {
            if (i % this.xCaptionGranularity == 0) {
                graphics2D.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 5), Math.round(f), dimension.height);
                graphics2D.drawString(Integer.toString(i), Math.round(f), dimension.height - 3);
            } else if (i % 5 == 0) {
                graphics2D.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 7), Math.round(f), dimension.height - (this.yLowerMargin - 15));
            } else {
                graphics2D.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 10), Math.round(f), dimension.height - (this.yLowerMargin - 15));
            }
            f += this.stepX;
        }
    }

    protected void paintYAxis(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = this.yLowerMargin;
        graphics2D.setColor(this.axisColor);
        graphics2D.drawLine(this.xLeftMargin - 15, this.yTopMargin, this.xLeftMargin - 15, dimension.height - this.yLowerMargin + 15);
        int n = 1;
        for (float f3 = this.minY; f3 < this.maxY; f3 += this.yGranularity) {
            f2 = (this.maxY - f3) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            if (n % this.yCaptionGranularity == 0) {
                graphics2D.drawLine(0, Math.round(f2), this.xLeftMargin - 5, Math.round(f2));
                StringBuffer stringBuffer = new StringBuffer(Float.toString(f3));
                if (stringBuffer.length() > this.yCaptionLength) {
                    stringBuffer.setLength(this.yCaptionLength);
                }
                graphics2D.drawString(stringBuffer.toString(), 3, Math.round(f2) - 5);
            } else if (n % 5 == 0) {
                graphics2D.drawLine(this.xLeftMargin - 7, Math.round(f2), this.xLeftMargin - 15, Math.round(f2));
            } else {
                graphics2D.drawLine(this.xLeftMargin - 10, Math.round(f2), this.xLeftMargin - 15, Math.round(f2));
            }
            ++n;
        }
    }

    protected void paintLocator(Graphics2D graphics2D) {
        String string;
        Dimension dimension = this.getSize();
        if (!this.bDrawLocator) {
            return;
        }
        graphics2D.setColor(this.locatorColor);
        graphics2D.drawLine(this.X, 0, this.X, dimension.height);
        graphics2D.drawLine(0, this.Y, dimension.width, this.Y);
        graphics2D.setColor(this.locatorCaption);
        String string2 = Float.toString(this.gridY);
        if (string2.length() > 5) {
            string2 = string2.substring(0, 5);
        }
        if ((string = Float.toString(this.gridX)).length() > 5) {
            string = string.substring(0, 5);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string3 = "(" + string + "," + string2 + ")";
        Point point = this.checkVisible(string3, fontMetrics, dimension, this.X + 5, this.Y - 5);
        int n = point.x;
        int n2 = point.y;
        if (this.bOpaqueCoords) {
            graphics2D.setColor(new Color(102, 102, 153));
            graphics2D.draw(new Rectangle(n, n2 - fontMetrics.getHeight() - 5, fontMetrics.stringWidth(string3) + 10, fontMetrics.getHeight() + 5));
            graphics2D.setColor(new Color(204, 204, 255));
            graphics2D.fill(new Rectangle(n + 1, n2 - fontMetrics.getHeight() - 4, fontMetrics.stringWidth(string3) + 9, fontMetrics.getHeight() + 4));
            graphics2D.setColor(this.locatorCaption);
        }
        graphics2D.drawString(string3, n + 5, n2 - 5);
    }

    private Point checkVisible(String string, FontMetrics fontMetrics, Dimension dimension, int n, int n2) {
        if (n + fontMetrics.stringWidth(string) > dimension.width) {
            n = this.X - 5 - fontMetrics.stringWidth(string);
        }
        if (n2 - fontMetrics.getHeight() < 0) {
            n2 += 5 + fontMetrics.getHeight();
        }
        return new Point(n, n2);
    }

    protected void paintCurve(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = -1.0f;
        float f3 = this.yLowerMargin;
        float f4 = -1.0f;
        for (int i = this.minElement; i <= this.maxElement; ++i) {
            float f5 = this.script.getGraphData(this.index, (TElement)this.elements.get(new Integer(i)));
            f3 = (this.maxY - f5) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            if ((double)f4 < 0.0) {
                f4 = f3;
            }
            if ((double)f2 < 0.0) {
                f2 = f;
            }
            if (f5 != this.invalid) {
                if (i == this.selectedAtom) {
                    graphics2D.setColor(this.labelColor);
                    graphics2D.drawString("Selection: " + Float.toString(f5) + " " + this.units, 0, 15);
                }
                graphics2D.setColor(this.curveColor);
                graphics2D.drawLine(Math.round(f2), Math.round(f4), Math.round(f), Math.round(f3));
                if (i == this.selectedAtom) {
                    String string;
                    String string2;
                    graphics2D.setColor(this.selectedColor);
                    graphics2D.drawLine(Math.round(f), 0, Math.round(f), dimension.height);
                    graphics2D.drawLine(0, Math.round(f3), dimension.width, Math.round(f3));
                    String string3 = Float.toString(this.getGridY(Math.round(f3)));
                    if (string3.length() > 5) {
                        string3 = string3.substring(0, 5);
                    }
                    if ((string2 = Float.toString(this.getGridX(Math.round(f)))).length() > 5) {
                        string2 = string2.substring(0, 5);
                    }
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    int n = Math.round(f) + 5;
                    if (n + fontMetrics.stringWidth(string = "(" + string2 + "," + string3 + ")") > dimension.width) {
                        n = Math.round(f) - 5 - fontMetrics.stringWidth(string);
                    }
                    int n2 = Math.round(f3) + 5 + graphics2D.getFontMetrics().getHeight();
                    if (this.bOpaqueCoords) {
                        graphics2D.setColor(new Color(102, 102, 153));
                        graphics2D.draw(new Rectangle(n, n2 - fontMetrics.getHeight(), fontMetrics.stringWidth(string) + 10, fontMetrics.getHeight() + 5));
                        graphics2D.setColor(new Color(204, 204, 255));
                        graphics2D.fill(new Rectangle(n + 1, n2 - fontMetrics.getHeight() + 1, fontMetrics.stringWidth(string) + 9, fontMetrics.getHeight() + 4));
                        graphics2D.setColor(this.locatorCaption);
                    }
                    graphics2D.drawString(string, n + 5, n2);
                    graphics2D.setColor(this.axisColor);
                }
                f2 = f;
                f4 = f3;
            } else if (!this.bInterpolateMissing) {
                f2 = -1.0f;
                f4 = -1.0f;
            }
            f += this.stepX;
        }
    }

    public BufferedImage createBufferedImage(int n, int n2, int n3) {
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(n, n2, n3);
        biw = n;
        bih = n2;
        return bufferedImage;
    }

    private void fixG2D(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setFont(this.getFont());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl;
        if (!this.fontInited && this.getParent() != null) {
            this.setFont(this.getParent().getFont());
            this.fontInited = true;
        }
        Dimension dimension = this.getSize();
        boolean bl2 = bl = biw != dimension.width || bih != dimension.height;
        if (iBuffer == null || bl) {
            if (this.emm != null) {
                this.doMouseMove(this.emm.getX(), this.emm.getY());
            }
            iBuffer = this.createBufferedImage(dimension.width, dimension.height, 5);
            biw = dimension.width;
            bih = dimension.height;
        }
        if (iBack == null || bl) {
            iBack = this.createBufferedImage(dimension.width, dimension.height, 5);
        }
        Graphics2D graphics2D = (Graphics2D)iBuffer.getGraphics();
        this.fixG2D(graphics2D);
        if (bl || this.mustRepaint) {
            Graphics2D graphics2D2 = (Graphics2D)iBack.getGraphics();
            this.fixG2D(graphics2D2);
            this.stepX = ((float)this.getSize().width - (float)this.xLeftMargin - 1.0f) / (float)(this.maxElement - this.minElement);
            this.stepY = ((float)this.getSize().height - (float)this.yLowerMargin - 1.0f) / (this.maxY - this.minY);
            this.paintBackground(graphics2D2);
            this.paintGrid(graphics2D2);
            this.paintXAxis(graphics2D2);
            this.paintYAxis(graphics2D2);
            this.paintCurve(graphics2D2);
        }
        graphics2D.drawImage((Image)iBack, 0, 0, null);
        this.paintLocator(graphics2D);
        graphics.drawImage(iBuffer, 0, 0, null);
        this.mustRepaint = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        this.ppmgr.setAtom(Math.round(this.gridX));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.doMouseMove(mouseEvent.getX(), mouseEvent.getY());
        this.emm = mouseEvent;
    }

    private void doMouseMove(int n, int n2) {
        this.X = n > this.xLeftMargin ? n : this.xLeftMargin;
        this.gridX = this.getGridX(this.X);
        if (this.gridX < 0.0f) {
            this.gridX = 0.0f;
        }
        if (!this.bDrawLocator) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.bLocatorFollowCurve) {
            int n3 = Math.round(this.getGridX(n));
            if (n3 < this.minElement || n3 > this.maxElement) {
                this.Y = Math.round(this.invalid);
                return;
            }
            float f = this.script.getGraphData(this.index, (TElement)this.elements.get(new Integer(n3)));
            this.Y = Math.round((this.maxY - f) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin));
        } else {
            this.Y = n2 < dimension.height - this.yLowerMargin ? n2 : dimension.height - this.yLowerMargin;
        }
        this.gridY = this.getGridY(this.Y);
        if (this.gridY < 0.0f) {
            this.gridY = 0.0f;
        }
        this.repaint();
    }

    private int getPixelX(float f) {
        Dimension dimension = this.getSize();
        float f2 = f / (float)(this.maxElement - this.minElement);
        return Math.round(f2 * (float)(dimension.width - this.xLeftMargin));
    }

    private int getPixelY(float f) {
        Dimension dimension = this.getSize();
        float f2 = 1.0f - f / (this.maxY - this.minY);
        return Math.round(f2 * (float)(dimension.height - this.yLowerMargin));
    }

    private float getGridY(int n) {
        Dimension dimension = this.getSize();
        float f = dimension.height - this.yLowerMargin;
        float f2 = 1.0f - (float)n / f;
        return (this.maxY - this.minY) * f2 + this.minY;
    }

    private float getGridX(int n) {
        Dimension dimension = this.getSize();
        float f = dimension.width - this.xLeftMargin;
        float f2 = (float)(n - this.xLeftMargin) / f;
        return (float)(this.maxElement - this.minElement) * f2 + (float)this.minElement;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.ppmgr.setAtom(Math.round(this.gridX));
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSaveGraph")) {
            this.OnFileSaveGraph();
        } else if (string.equals("FilePrintGraph")) {
            this.OnFilePrintGraph();
        }
    }

    private void OnFileSaveGraph() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("jpg", "JPEG image");
            SimpleFileFilter simpleFileFilter2 = new SimpleFileFilter("bmp", "Windows Bitmap");
            FileFilter[] fileFilterArray = new FileFilter[]{simpleFileFilter, simpleFileFilter2};
            DoFileDialog doFileDialog = new DoFileDialog((Component)this, "Save Graph Image...", 1, fileFilterArray);
            String string = doFileDialog.getPath();
            if (string.equals("")) {
                return;
            }
            String string2 = DoFileDialog.getExtension(string);
            this.sbb.setText("Saving " + string + "...");
            if (string2.equals(".bmp")) {
                BitmapCodec bitmapCodec = new BitmapCodec(this);
                if (iBuffer == null) {
                    this.repaint();
                }
                bitmapCodec.saveBitmap(string, iBuffer);
            } else if (string2.equals(".jpg")) {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                jPEGImageEncoder.encode(iBuffer);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            this.sbb.setText("Saved " + string + ".");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onActivate(PanelEvent panelEvent) {
        this.activated = true;
        this.mustRepaint = true;
        this.repaint();
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.activated = true;
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void setStyle(PanelEvent panelEvent) {
        int n = panelEvent.getStyle();
        this.bInterpolateMissing = (n & 1) != 0;
        this.bDrawLocator = (n & 2) != 0;
        this.bLocatorFollowCurve = (n & 4) != 0;
        this.bOpaqueCoords = (n & 8) != 0;
        this.mustRepaint = true;
        this.repaint();
    }

    public String toString() {
        return this.caption;
    }

    private void OnFilePrintGraph() {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

