/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BitmapCodec
extends Component
implements Runnable {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private BufferedOutputStream fo;
    private Component owner = null;
    private String parFilename;
    private Image parImage;
    private int parWidth;
    private int parHeight;

    public BitmapCodec(Component component) {
        this.owner = component;
    }

    public void run() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.parFilename);
            this.fo = new BufferedOutputStream(fileOutputStream, 262144);
            this.save(this.parImage, this.parWidth, this.parHeight);
            this.fo.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveBitmap(String string, Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        this.parFilename = string;
        if (this.owner != null) {
            this.parImage = this.owner.createImage(n, n2);
            if (this.parImage == null) {
                this.parImage = image;
            }
            this.parImage.getGraphics().drawImage(image, 0, 0, null);
        } else {
            this.parImage = image;
        }
        this.parWidth = n;
        this.parHeight = n2;
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    private void save(Image image, int n, int n2) {
        try {
            this.convertImage(image, n, n2);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean convertImage(Image image, int n, int n2) {
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        int n3 = (4 - n * 3 % 4) * n2;
        this.biSizeImage = n * n2 * 3 + n3;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = n;
        this.biHeight = n2;
        return true;
    }

    private void writeBitmap() {
        int n;
        byte[] byArray = new byte[3];
        int n2 = this.biWidth * this.biHeight - 1;
        int n3 = 4 - this.biWidth * 3 % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = n = n2 - this.biWidth;
        try {
            for (int i = 0; i < n2; ++i) {
                int n7 = this.bitmap[n];
                byArray[0] = (byte)(n7 & 0xFF);
                byArray[1] = (byte)(n7 >> 8 & 0xFF);
                byArray[2] = (byte)(n7 >> 16 & 0xFF);
                this.fo.write(byArray);
                if (n4 == this.biWidth) {
                    n5 += n3;
                    for (int j = 1; j <= n3; ++j) {
                        this.fo.write(0);
                    }
                    n4 = 1;
                    n6 = n = n6 - this.biWidth;
                } else {
                    ++n4;
                }
                ++n;
            }
            this.bfSize += n5 - n3;
            this.biSizeImage += n5 - n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public Image loadbitmap(String string, String string2) {
        System.out.println("loading:" + string + string2);
        try {
            Image image;
            FileInputStream fileInputStream = new FileInputStream(string + string2);
            int n = 14;
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray, 0, n);
            int n2 = 40;
            byte[] byArray2 = new byte[n2];
            fileInputStream.read(byArray2, 0, n2);
            int n3 = (byArray[5] & 0xFF) << 24 | (byArray[4] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
            System.out.println("File type is :" + (char)byArray[0] + (char)byArray[1]);
            System.out.println("Size of file is :" + n3);
            int n4 = (byArray2[3] & 0xFF) << 24 | (byArray2[2] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF;
            System.out.println("Size of bitmapinfoheader is :" + n4);
            int n5 = (byArray2[7] & 0xFF) << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF;
            System.out.println("Width is :" + n5);
            int n6 = (byArray2[11] & 0xFF) << 24 | (byArray2[10] & 0xFF) << 16 | (byArray2[9] & 0xFF) << 8 | byArray2[8] & 0xFF;
            System.out.println("Height is :" + n6);
            int n7 = (byArray2[13] & 0xFF) << 8 | byArray2[12] & 0xFF;
            System.out.println("Planes is :" + n7);
            int n8 = (byArray2[15] & 0xFF) << 8 | byArray2[14] & 0xFF;
            System.out.println("BitCount is :" + n8);
            int n9 = byArray2[19] << 24 | byArray2[18] << 16 | byArray2[17] << 8 | byArray2[16];
            System.out.println("Compression is :" + n9);
            int n10 = (byArray2[23] & 0xFF) << 24 | (byArray2[22] & 0xFF) << 16 | (byArray2[21] & 0xFF) << 8 | byArray2[20] & 0xFF;
            System.out.println("SizeImage is :" + n10);
            int n11 = (byArray2[27] & 0xFF) << 24 | (byArray2[26] & 0xFF) << 16 | (byArray2[25] & 0xFF) << 8 | byArray2[24] & 0xFF;
            System.out.println("X-Pixels per meter is :" + n11);
            int n12 = (byArray2[31] & 0xFF) << 24 | (byArray2[30] & 0xFF) << 16 | (byArray2[29] & 0xFF) << 8 | byArray2[28] & 0xFF;
            System.out.println("Y-Pixels per meter is :" + n12);
            int n13 = (byArray2[35] & 0xFF) << 24 | (byArray2[34] & 0xFF) << 16 | (byArray2[33] & 0xFF) << 8 | byArray2[32] & 0xFF;
            System.out.println("Colors used are :" + n13);
            int n14 = (byArray2[39] & 0xFF) << 24 | (byArray2[38] & 0xFF) << 16 | (byArray2[37] & 0xFF) << 8 | byArray2[36] & 0xFF;
            System.out.println("Colors important are :" + n14);
            if (n8 == 24) {
                int n15 = n10 / n6 - n5 * 3;
                int[] nArray = new int[n6 * n5];
                byte[] byArray3 = new byte[(n5 + n15) * 3 * n6];
                fileInputStream.read(byArray3, 0, (n5 + n15) * 3 * n6);
                int n16 = 0;
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        nArray[n5 * (n6 - i - 1) + j] = 0xFF000000 | (byArray3[n16 + 2] & 0xFF) << 16 | (byArray3[n16 + 1] & 0xFF) << 8 | byArray3[n16] & 0xFF;
                        n16 += 3;
                    }
                    n16 += n15;
                }
                image = this.createImage(new MemoryImageSource(n5, n6, nArray, 0, n5));
            } else if (n8 == 8) {
                int n17;
                int n18 = 0;
                n18 = n13 > 0 ? n13 : 1 << n8;
                System.out.println("The number of Colors is" + n18);
                if (n10 == 0) {
                    n10 = (n5 * n8 + 31 & 0xFFFFFFE0) >> 3;
                    System.out.println("nsizeimage (backup) is" + (n10 *= n6));
                }
                int[] nArray = new int[n18];
                byte[] byArray4 = new byte[n18 * 4];
                fileInputStream.read(byArray4, 0, n18 * 4);
                int n19 = 0;
                for (n17 = 0; n17 < n18; ++n17) {
                    nArray[n17] = 0xFF000000 | (byArray4[n19 + 2] & 0xFF) << 16 | (byArray4[n19 + 1] & 0xFF) << 8 | byArray4[n19] & 0xFF;
                    n19 += 4;
                }
                n17 = n10 / n6 - n5;
                System.out.println("nPad is:" + n17);
                int[] nArray2 = new int[n5 * n6];
                byte[] byArray5 = new byte[(n5 + n17) * n6];
                fileInputStream.read(byArray5, 0, (n5 + n17) * n6);
                n19 = 0;
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        nArray2[n5 * (n6 - i - 1) + j] = nArray[byArray5[n19] & 0xFF];
                        ++n19;
                    }
                    n19 += n17;
                }
                image = this.createImage(new MemoryImageSource(n5, n6, nArray2, 0, n5));
            } else {
                System.out.println("Not a 24-bit or 8-bit Windows Bitmap, aborting...");
                image = null;
            }
            fileInputStream.close();
            return image;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in loadbitmap!");
            return null;
        }
    }
}

