import java.util.*;
import java.awt.*;
import java.applet.*;

//Java Information Utility
//Copyright (C) 1999 DW Software.  All Rights Reserved.

public class JInfo10 extends Applet {
    public static void main(String args[]) {
        getInfo();
        System.exit(0);
    }
 
    public static void getInfo(){
        //Screen size and dpi
        Toolkit tk = Toolkit.getDefaultToolkit();
        int resolution = tk.getScreenResolution();
        Dimension dim = tk.getScreenSize();
 
        StringBuffer sb = new StringBuffer();
        sb.append("Screen Resolution (in dpi): " + String.valueOf(resolution));
        sb.append(" Screen size: " + dim.width + "x" + dim.height + "\n");
        //font list
        String fonts[] = tk.getFontList();
        sb.append("Fonts Available:\n");
        for(int i = 0; i < fonts.length; i++){
       	sb.append("     \"" + fonts[i] + "\"\n");
        }
        //current time
        long time = System.currentTimeMillis();
        sb.append("It has been " + time + " milliseconds since January 1st, 1970\n");
        //properties
        try{
            sb.append("System Properties:\n");
            sb.append("     Java version: " + System.getProperty("java.version") + "\n");
            sb.append("     Java vendor: " + System.getProperty("java.vendor") + "\n");
            sb.append("     Java vendor's URL: " + System.getProperty("java.vendor.url") + "\n");
            sb.append("     Home Java folder: " + System.getProperty("java.home") + "\n");
            sb.append("     Java class version: " + System.getProperty("java.class.version") + "\n");
            sb.append("     Java class path: " + System.getProperty("java.class.path") + "\n");
            sb.append("     Operating System: " + System.getProperty("os.name") + "\n");
            sb.append("     Operating system architecture: " + System.getProperty("os.arch") + "\n");
            sb.append("     Operating system version: " + System.getProperty("os.version") + "\n");
            sb.append("     File separator: " + System.getProperty("file.separator") + "\n");
            sb.append("     Path separator: " + System.getProperty("path.separator") + "\n");
            sb.append("     User name: " + System.getProperty("user.name") + "\n");
            sb.append("     User's home directory: " + System.getProperty("user.home") + "\n");
            sb.append("     Current working directory: " + System.getProperty("user.dir") + "\n");
        } catch (Exception e) {;}
        //memory
        sb.append("System Memory Information:\n");
        Runtime r = Runtime.getRuntime();
        r.gc();
        sb.append("     Free memory: " + r.freeMemory() + " bytes\n");
        sb.append("     Total memory: " + r.totalMemory() + " bytes\n");
        sb.append("     Memory in use: " + (r.totalMemory() - r.freeMemory()) + " bytes\n");
 
        //Now just list ALL properties...
        try{
            sb.append("Dump of all defined properties:\n");
            Properties props = System.getProperties();
            Enumeration enu = props.propertyNames();
            String name;
 
            while(enu.hasMoreElements()) {
              try {
                name = (String) enu.nextElement();
                if(name.equals("line.separator")) continue;
                sb.append("     \""+name+"\" = \""+System.getProperty(name) + "\"\n");
              } catch (Exception e) {}
            }
        } catch (Exception e){;}
 
        String temp = System.getProperty("line.separator");
        String pmet = "";
        for(int i = 0; i < temp.length(); i++) {
            char x = temp.charAt(i);
            if(x == '\r') pmet += "\\r";//pmet += "0x000D";
            else if(x == '\n') pmet += "\\n";//pmet += "0x000A";
            else pmet += x;
        }
        sb.append("     \"line.separator\" = \""+pmet+"\"\n");
 
        sb.append("=== End of output ===\n");
        System.out.println(sb.toString());
    }
}
