/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

class PoolItem
implements ElementInfo {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public static final int CONSTANT_Unknown = -1;
    public static final int CONSTANT_Error = -2;
    protected int tag;
    protected ConstantPoolInfo constants;
    public boolean resolved;
    protected StatusKeeper stats;
    protected int num;
    public boolean basicType;
    protected DefaultMutableTreeNode Description;

    public boolean isDoubleWide() {
        return this.tag == 6 || this.tag == 5;
    }

    public String getUtf8() {
        return "";
    }

    public String getName() {
        switch (this.tag) {
            case 7: {
                return "Class";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 8: {
                return "String";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameAndType";
            }
            case 1: {
                return "Utf8";
            }
            case -2: {
                return "Error";
            }
            case -1: {
                return "Unknown" + this.tag;
            }
        }
        return "Unknown " + this.tag;
    }

    public String getSignature() {
        return "NONE";
    }

    public DefaultMutableTreeNode Describe() {
        return this.Description;
    }

    public String toString() {
        return this.getName();
    }

    public static PoolItem pullPoolItem(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream, StatusKeeper statusKeeper, int n) {
        int n2;
        try {
            n2 = dataInputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            System.out.println("poolitem" + iOException);
            n2 = -2;
        }
        switch (n2) {
            case 7: {
                return new Class_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 9: {
                return new Fieldref_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 10: {
                return new Methodref_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 8: {
                return new String_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 3: {
                return new Integer_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 4: {
                return new Float_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 5: {
                return new Long_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 6: {
                return new Double_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 11: {
                return new IMethodref_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 12: {
                return new NameAndType_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 1: {
                return new Utf8_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
            case 2: {
                return new Unicode_info(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
            }
        }
        return new PoolItem(constantPoolInfo, n2, dataInputStream, statusKeeper, n);
    }

    public PoolItem(ConstantPoolInfo constantPoolInfo, int n, DataInputStream dataInputStream, StatusKeeper statusKeeper, int n2) {
        this.resolved = false;
        this.basicType = false;
        this.tag = n;
        this.Description = new DefaultMutableTreeNode("PoolItemError");
        this.constants = constantPoolInfo;
        System.out.println("Error: Unknown constant [" + n + ']');
        this.stats = statusKeeper;
        this.num = n2;
    }

    public PoolItem() {
        this.tag = -1;
        this.resolved = false;
    }
}

