/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

public class InterfaceInfo
implements ElementInfo {
    int count;
    ConstantPoolInfo constants;
    InterfaceItem[] interfaces;
    StatusKeeper stats;

    public DefaultMutableTreeNode Describe() {
        if (this.count == 0) {
            return new DefaultMutableTreeNode("No Interfaces");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Interfaces: " + this.count + " items.");
        int n = 0;
        while (n < this.count) {
            defaultMutableTreeNode.add(this.interfaces[n].Describe());
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public InterfaceInfo(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream, StatusKeeper statusKeeper) {
        try {
            this.stats = statusKeeper;
            this.constants = constantPoolInfo;
            this.count = dataInputStream.readUnsignedShort();
            if (this.count != 0) {
                this.interfaces = new InterfaceItem[this.count];
                int n = 0;
                while (n < this.count) {
                    this.interfaces[n] = new InterfaceItem(constantPoolInfo, dataInputStream, this.stats, n);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("" + iOException);
        }
    }
}

