/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class ByteCodeInfo
implements ElementInfo {
    ConstantPoolInfo constants;
    int code_length;
    int codepos;
    int[] code;

    public DefaultMutableTreeNode Describe() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Byte Codes: " + this.code_length + " bytes");
        this.codepos = 0;
        if (this.code.length > 16384) {
            SimpleFileFilter simpleFileFilter;
            String string;
            JFrame jFrame = new JFrame("this");
            jFrame.setVisible(false);
            if (JOptionPane.showConfirmDialog(jFrame, "The method I am disassembling is longer than 16,384 bytes, and the tree hasn't enough memory.\n\nWould you like me to print the full listing to a file instead?", "Insufficient Memory for Disassembly", 0, 3) == 0 && !(string = DoFileDialog.GetFileName(jFrame, "Save a method dump", 1, simpleFileFilter = new SimpleFileFilter("txt", "Save a method dump"))).equals("")) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
                    while (this.codepos < this.code.length) {
                        dataOutputStream.writeBytes(this.decodeBytes() + "\r\n");
                    }
                    dataOutputStream.flush();
                    fileOutputStream.close();
                    this.codepos = 0;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        while (this.codepos < this.code.length) {
            if (this.codepos > 16384) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode("Method too large--bytes after 16K ignored."));
                break;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.decodeBytes()));
        }
        return defaultMutableTreeNode;
    }

    protected String decodeBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("" + this.codepos + ' ');
        switch (this.code[this.codepos++]) {
            case 0: {
                stringBuffer.append("nop\t\t\t\t\tNo operation");
                break;
            }
            case 1: {
                stringBuffer.append("aconst_null\t\t\tPush Null Object");
                break;
            }
            case 2: {
                stringBuffer.append("iconst_m1\t\t\t  Push -1");
                break;
            }
            case 3: {
                stringBuffer.append("iconst_0\t\t\t   Push 0");
                break;
            }
            case 4: {
                stringBuffer.append("iconst_1\t\t\t   Push 1");
                break;
            }
            case 5: {
                stringBuffer.append("iconst_2\t\t\t   Push 2");
                break;
            }
            case 6: {
                stringBuffer.append("iconst_3\t\t\t   Push 3");
                break;
            }
            case 7: {
                stringBuffer.append("iconst_4\t\t\t   Push 4");
                break;
            }
            case 8: {
                stringBuffer.append("iconst_5\t\t\t   Push 5");
                break;
            }
            case 9: {
                stringBuffer.append("lconst_0\t\t\t   Push 0L");
                break;
            }
            case 10: {
                stringBuffer.append("lconst_1\t\t\t   Push 1L");
                break;
            }
            case 11: {
                stringBuffer.append("fconst_0\t\t\t   Push 0.0");
                break;
            }
            case 12: {
                stringBuffer.append("fconst_1\t\t\t   Push 1.0");
                break;
            }
            case 13: {
                stringBuffer.append("fconst_2\t\t\t   Push 2.0");
                break;
            }
            case 14: {
                stringBuffer.append("dconst_0\t\t\t   Push 0.0 (double)");
                break;
            }
            case 15: {
                stringBuffer.append("dconst_1\t\t\t   Push 1.0 (double)");
                break;
            }
            case 16: {
                stringBuffer.append("bipush" + this.enumBytes(1) + "\t\t\t Push One-Byte Signed Integer");
                break;
            }
            case 17: {
                stringBuffer.append("sipush" + this.enumWords(1) + "\t\t\t Push Two-Byte Signed Integer");
                break;
            }
            case 18: {
                stringBuffer.append("ldc1" + this.poolIndex(1) + "\t\t\t   Push Item From Constant Pool (8 bit index)");
                break;
            }
            case 19: {
                stringBuffer.append("ldc2" + this.poolIndex(2) + "\t\t\t   Push Item From Constant Pool (16 bit index)");
                break;
            }
            case 20: {
                stringBuffer.append("ldc2w" + this.poolIndex(2) + "\t\t\t  Push Long or Double from Constant Pool (16 bit index)");
                break;
            }
            case 21: {
                stringBuffer.append("iload" + this.enumBytes(1) + "\t\t\t  Push contents of vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 22: {
                stringBuffer.append("lload" + this.enumBytes(1) + "\t\t\t  Push Long from vars[" + this.code[this.codepos - 1] + "] & vars[" + (this.code[this.codepos - 1] + 1) + ']');
                break;
            }
            case 23: {
                stringBuffer.append("fload" + this.enumBytes(1) + "\t\t\t  Push Float from vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 24: {
                stringBuffer.append("dload" + this.enumBytes(1) + "\t\t\t  Push Double from vars[" + this.code[this.codepos - 1] + "] & vars[" + (this.code[this.codepos - 1] + 1) + ']');
                break;
            }
            case 25: {
                stringBuffer.append("aload" + this.enumBytes(1) + "\t\t\t  Push Object from vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 26: {
                stringBuffer.append("iload_0\t\t\t\tPush Integer from vars[0] (this pointer)");
                break;
            }
            case 27: {
                stringBuffer.append("iload_1\t\t\t\tPush Integer from vars[1]");
                break;
            }
            case 28: {
                stringBuffer.append("iload_2\t\t\t\tPush Integer from vars[2]");
                break;
            }
            case 29: {
                stringBuffer.append("iload_3\t\t\t\tPush Integer from vars[3]");
                break;
            }
            case 30: {
                stringBuffer.append("lload_0\t\t\t\tPush Long from vars[0] & vars[1]");
                break;
            }
            case 31: {
                stringBuffer.append("lload_1\t\t\t\tPush Long from vars[1] & vars[2]");
                break;
            }
            case 32: {
                stringBuffer.append("lload_2\t\t\t\tPush Long from vars[2] & vars[3]");
                break;
            }
            case 33: {
                stringBuffer.append("lload_3\t\t\t\tPush Long from vars[3] & vars[4]");
                break;
            }
            case 34: {
                stringBuffer.append("fload_0\t\t\t\tPush Float from vars[0]");
                break;
            }
            case 35: {
                stringBuffer.append("fload_1\t\t\t\tPush Float from vars[1]");
                break;
            }
            case 36: {
                stringBuffer.append("fload_2\t\t\t\tPush Float from vars[2]");
                break;
            }
            case 37: {
                stringBuffer.append("fload_3\t\t\t\tPush Float from vars[3]");
                break;
            }
            case 38: {
                stringBuffer.append("dload_0\t\t\t\tPush Double from vars[0] & vars[1]");
                break;
            }
            case 39: {
                stringBuffer.append("dload_1\t\t\t\tPush Double from vars[1] & vars[2]");
                break;
            }
            case 40: {
                stringBuffer.append("dload_2\t\t\t\tPush Double from vars[2] & vars[3]");
                break;
            }
            case 41: {
                stringBuffer.append("dload_3\t\t\t\tPush Double from vars[3] & vars[4]");
                break;
            }
            case 42: {
                stringBuffer.append("aload_0\t\t\t\tPush Object from vars[0] (this)");
                break;
            }
            case 43: {
                stringBuffer.append("aload_1\t\t\t\tPush Object from vars[1]");
                break;
            }
            case 44: {
                stringBuffer.append("aload_2\t\t\t\tPush Object from vars[2]");
                break;
            }
            case 45: {
                stringBuffer.append("aload_3\t\t\t\tPush Object from vars[3]");
                break;
            }
            case 46: {
                stringBuffer.append("iaload\t\t\t\t Push Integer from array on stack");
                break;
            }
            case 47: {
                stringBuffer.append("laload\t\t\t\t Push long from array on stack");
                break;
            }
            case 48: {
                stringBuffer.append("faload\t\t\t\t Push Float from array on stack");
                break;
            }
            case 49: {
                stringBuffer.append("daload\t\t\t\t Push Double from array on stack");
                break;
            }
            case 50: {
                stringBuffer.append("aaload\t\t\t\t Push Object from array on stack");
                break;
            }
            case 51: {
                stringBuffer.append("baload\t\t\t\t Push Byte from array on stack");
                break;
            }
            case 52: {
                stringBuffer.append("caload\t\t\t\t Push Char from array on stack");
                break;
            }
            case 53: {
                stringBuffer.append("saload\t\t\t\t Push Short from array on stack");
                break;
            }
            case 54: {
                stringBuffer.append("istore" + this.enumBytes(1) + "\t\t\t Store Integer on stack into vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 55: {
                stringBuffer.append("lstore" + this.enumBytes(1) + "\t\t\t Store Long on stack into vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 56: {
                stringBuffer.append("fstore" + this.enumBytes(1) + "\t\t\t Store Float on stack into vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 57: {
                stringBuffer.append("dstore" + this.enumBytes(1) + "\t\t\t Store Double on stack into vars[" + this.code[this.codepos - 1] + "] & vars[" + (this.code[this.codepos - 1] + 1) + ']');
                break;
            }
            case 58: {
                stringBuffer.append("astore" + this.enumBytes(1) + "\t\t\t Store Object on stack into vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 59: {
                stringBuffer.append("istore_0\t\t\t   Store Integer on stack into vars[0]");
                break;
            }
            case 60: {
                stringBuffer.append("istore_1\t\t\t   Store Integer on stack into vars[1]");
                break;
            }
            case 61: {
                stringBuffer.append("istore_2\t\t\t   Store Integer on stack into vars[2]");
                break;
            }
            case 62: {
                stringBuffer.append("istore_3\t\t\t   Store Integer on stack into vars[3]");
                break;
            }
            case 63: {
                stringBuffer.append("lstore_0\t\t\t   Store Long on stack into vars[0] & vars[1]");
                break;
            }
            case 64: {
                stringBuffer.append("lstore_1\t\t\t   Store Long on stack into vars[1] & vars[2]");
                break;
            }
            case 65: {
                stringBuffer.append("lstore_2\t\t\t   Store Long on stack into vars[2] & vars[3]");
                break;
            }
            case 66: {
                stringBuffer.append("lstore_3\t\t\t   Store Long on stack into vars[3] & vars[4]");
                break;
            }
            case 67: {
                stringBuffer.append("fstore_0\t\t\t   Store Float on stack into vars[0]");
                break;
            }
            case 68: {
                stringBuffer.append("fstore_1\t\t\t   Store Float on stack into vars[1]");
                break;
            }
            case 69: {
                stringBuffer.append("fstore_2\t\t\t   Store Float on stack into vars[2]");
                break;
            }
            case 70: {
                stringBuffer.append("fstore_3\t\t\t   Store Float on stack into vars[3]");
                break;
            }
            case 71: {
                stringBuffer.append("dstore_0\t\t\t   Store Double on stack into vars[0] & vars[1]");
                break;
            }
            case 72: {
                stringBuffer.append("dstore_1\t\t\t   Store Double on stack into vars[1] & vars[2]");
                break;
            }
            case 73: {
                stringBuffer.append("dstore_2\t\t\t   Store Double on stack into vars[2] & vars[3]");
                break;
            }
            case 74: {
                stringBuffer.append("dstore_3\t\t\t   Store Double on stack into vars[3] & vars[4]");
                break;
            }
            case 75: {
                stringBuffer.append("astore_0\t\t\t   Store Object on stack into vars[0]");
                break;
            }
            case 76: {
                stringBuffer.append("astore_1\t\t\t   Store Object on stack into vars[1]");
                break;
            }
            case 77: {
                stringBuffer.append("astore_2\t\t\t   Store Object on stack into vars[2]");
                break;
            }
            case 78: {
                stringBuffer.append("astore_3\t\t\t   Store Object on stack into vars[3]");
                break;
            }
            case 79: {
                stringBuffer.append("iastore\t\t\t\tStore Integer on stack into array on stack");
                break;
            }
            case 80: {
                stringBuffer.append("lastore\t\t\t\tStore Long on stack into array on stack");
                break;
            }
            case 81: {
                stringBuffer.append("fastore\t\t\t\tStore Float on stack into array on stack");
                break;
            }
            case 82: {
                stringBuffer.append("dastore\t\t\t\tStore Double on stack into array on stack");
                break;
            }
            case 83: {
                stringBuffer.append("aastore\t\t\t\tStore Object on stack into array on stack");
                break;
            }
            case 84: {
                stringBuffer.append("bastore\t\t\t\tStore Byte on stack into array on stack");
                break;
            }
            case 85: {
                stringBuffer.append("castore\t\t\t\tStore Char on stack into array on stack");
                break;
            }
            case 86: {
                stringBuffer.append("sastore\t\t\t\tStore Short on stack into array on stack");
                break;
            }
            case 87: {
                stringBuffer.append("pop\t\t\t\t\tRemove top stack element");
                break;
            }
            case 88: {
                stringBuffer.append("pop2\t\t\t\t   Remove top two stack elements");
                break;
            }
            case 89: {
                stringBuffer.append("dup\t\t\t\t\tInsert a copy of top stack element at stack[top]");
                break;
            }
            case 90: {
                stringBuffer.append("dup_x1\t\t\t\t Insert a copy of top stack element at stack[top - 1]");
                break;
            }
            case 91: {
                stringBuffer.append("dup_x2\t\t\t\t Insert a copy of top stack element at stack[top - 2]");
                break;
            }
            case 92: {
                stringBuffer.append("dup2\t\t\t\t   Insert a copy of top two stack elements at stack[top]");
                break;
            }
            case 93: {
                stringBuffer.append("dup2_x1\t\t\t\tInsert a copy of top two stack elements at stack[top - 1]");
                break;
            }
            case 94: {
                stringBuffer.append("dup2_x2\t\t\t\tInsert a copy of top two stack elements at stack[top - 2]");
                break;
            }
            case 95: {
                stringBuffer.append("swap\t\t\t\t   Swap top two stack elements");
                break;
            }
            case 96: {
                stringBuffer.append("iadd\t\t\t\t   Add top two stack integers");
                break;
            }
            case 97: {
                stringBuffer.append("ladd\t\t\t\t   Add top two stack longs");
                break;
            }
            case 98: {
                stringBuffer.append("fadd\t\t\t\t   Add top two stack floats");
                break;
            }
            case 99: {
                stringBuffer.append("dadd\t\t\t\t   Add top two stack doubles");
                break;
            }
            case 100: {
                stringBuffer.append("isub\t\t\t\t   Subtract top two stack integers");
                break;
            }
            case 101: {
                stringBuffer.append("lsub\t\t\t\t   Subtract top two stack longs");
                break;
            }
            case 102: {
                stringBuffer.append("fsub\t\t\t\t   Subtract top two stack floats");
                break;
            }
            case 103: {
                stringBuffer.append("dsub\t\t\t\t   Subtract top two stack doubles");
                break;
            }
            case 104: {
                stringBuffer.append("imul\t\t\t\t   Multiply top two stack integers");
                break;
            }
            case 105: {
                stringBuffer.append("lmul\t\t\t\t   Multiply top two stack longs");
                break;
            }
            case 106: {
                stringBuffer.append("fmul\t\t\t\t   Multiply top two stack floats");
                break;
            }
            case 107: {
                stringBuffer.append("dmul\t\t\t\t   Multiply top two stack doubles");
                break;
            }
            case 108: {
                stringBuffer.append("idiv\t\t\t\t   Divide top two stack integers");
                break;
            }
            case 109: {
                stringBuffer.append("ldiv\t\t\t\t   Divide top two stack longs");
                break;
            }
            case 110: {
                stringBuffer.append("fdiv\t\t\t\t   Divide top two stack floats");
                break;
            }
            case 111: {
                stringBuffer.append("ddiv\t\t\t\t   Divide top two stack doubles");
                break;
            }
            case 112: {
                stringBuffer.append("irem\t\t\t\t   Remainder of top two stack integers");
                break;
            }
            case 113: {
                stringBuffer.append("lrem\t\t\t\t   Remainder of top two stack longs");
                break;
            }
            case 114: {
                stringBuffer.append("frem\t\t\t\t   Remainder of top two stack floats");
                break;
            }
            case 115: {
                stringBuffer.append("drem\t\t\t\t   Remainder of top two stack doubles");
                break;
            }
            case 116: {
                stringBuffer.append("ineg\t\t\t\t   Negate top stack integer");
                break;
            }
            case 117: {
                stringBuffer.append("lneg\t\t\t\t   Negate top stack long");
                break;
            }
            case 118: {
                stringBuffer.append("fneg\t\t\t\t   Negate top stack float");
                break;
            }
            case 119: {
                stringBuffer.append("dneg\t\t\t\t   Negate top stack double");
                break;
            }
            case 120: {
                stringBuffer.append("ishl\t\t\t\t   Shift left stack integer by stack top bits");
                break;
            }
            case 121: {
                stringBuffer.append("lshl\t\t\t\t   Shift left stack long by stack top bits");
                break;
            }
            case 122: {
                stringBuffer.append("ishr\t\t\t\t   Shift right stack integer by stack top bits");
                break;
            }
            case 123: {
                stringBuffer.append("lshr\t\t\t\t   Shift right stack long by stack top bits");
                break;
            }
            case 124: {
                stringBuffer.append("iushr\t\t\t\t  Unsigned right integer shift by stack top bits");
                break;
            }
            case 125: {
                stringBuffer.append("lushr\t\t\t\t  Unsigned right long shift by stack top bits");
                break;
            }
            case 126: {
                stringBuffer.append("iand\t\t\t\t   Logical AND of top two stack integers");
                break;
            }
            case 127: {
                stringBuffer.append("land\t\t\t\t   Logical AND of top two stack longs");
                break;
            }
            case 128: {
                stringBuffer.append("ior\t\t\t\t\tLogical OR of top two stack integers");
                break;
            }
            case 129: {
                stringBuffer.append("lor\t\t\t\t\tLogical OR of top two stack longs");
                break;
            }
            case 130: {
                stringBuffer.append("ixor\t\t\t\t   Logical XOR of top two stack integers");
                break;
            }
            case 131: {
                stringBuffer.append("lxor\t\t\t\t   Logical XOR of top two stack longs");
                break;
            }
            case 132: {
                stringBuffer.append("iinc" + this.enumBytes(1) + ' ' + (byte)this.code[this.codepos++] + "\t\t   Increment vars[" + this.code[this.codepos - 2] + "] by " + (byte)this.code[this.codepos - 1]);
                break;
            }
            case 133: {
                stringBuffer.append("i2l\t\t\t\t\tConvert stack integer to long");
                break;
            }
            case 134: {
                stringBuffer.append("i2f\t\t\t\t\tConvert stack integer to float");
                break;
            }
            case 135: {
                stringBuffer.append("i2d\t\t\t\t\tConvert stack integer to double");
                break;
            }
            case 136: {
                stringBuffer.append("l2i\t\t\t\t\tConvert stack long to integer");
                break;
            }
            case 137: {
                stringBuffer.append("l2f\t\t\t\t\tConvert stack long to float");
                break;
            }
            case 138: {
                stringBuffer.append("l2d\t\t\t\t\tConvert stack long to double");
                break;
            }
            case 139: {
                stringBuffer.append("f2i\t\t\t\t\tConvert stack float to integer");
                break;
            }
            case 140: {
                stringBuffer.append("f2l\t\t\t\t\tConvert stack float to long");
                break;
            }
            case 141: {
                stringBuffer.append("f2d\t\t\t\t\tConvert stack float to double");
                break;
            }
            case 142: {
                stringBuffer.append("d2i\t\t\t\t\tConvert stack double to integer");
                break;
            }
            case 143: {
                stringBuffer.append("d2l\t\t\t\t\tConvert stack double to long");
                break;
            }
            case 144: {
                stringBuffer.append("d2f\t\t\t\t\tConvert stack double to float");
                break;
            }
            case 145: {
                stringBuffer.append("int2byte\t\t\t   Convert stack integer to byte");
                break;
            }
            case 146: {
                stringBuffer.append("int2char\t\t\t   Convert stack integer to char");
                break;
            }
            case 147: {
                stringBuffer.append("int2short\t\t\t  Convert stack integer to short");
                break;
            }
            case 148: {
                stringBuffer.append("lcmp\t\t\t\t   Compare top two longs");
                break;
            }
            case 149: {
                stringBuffer.append("fcmpl\t\t\t\t  Compare top two floats (-1 on NaN)");
                break;
            }
            case 150: {
                stringBuffer.append("fcmpg\t\t\t\t  Compare top two floats (1 on NaN)");
                break;
            }
            case 151: {
                stringBuffer.append("dcmpl\t\t\t\t  Compare top two doubles (-1 on NaN)");
                break;
            }
            case 152: {
                stringBuffer.append("dcmpg\t\t\t\t  Compare top two doubles (1 on NaN)");
                break;
            }
            case 153: {
                stringBuffer.append("ifeq" + this.branchLocation() + "\t\t\t   Branch if stack top equals zero");
                break;
            }
            case 154: {
                stringBuffer.append("ifne" + this.branchLocation() + "\t\t\t   Branch if stack top not equal zero");
                break;
            }
            case 155: {
                stringBuffer.append("iflt" + this.branchLocation() + "\t\t\t   Branch if stack top less than zero");
                break;
            }
            case 156: {
                stringBuffer.append("ifge" + this.branchLocation() + "\t\t\t   Branch if stack top greater than or equal to zero");
                break;
            }
            case 157: {
                stringBuffer.append("ifgt" + this.branchLocation() + "\t\t\t   Branch if stack top greater than zero");
                break;
            }
            case 158: {
                stringBuffer.append("ifle" + this.branchLocation() + "\t\t\t   Branch if stack top less than or equal to zero");
                break;
            }
            case 159: {
                stringBuffer.append("if_icmpeq" + this.branchLocation() + "\t\t  Branch if top two stack integers are equal");
                break;
            }
            case 160: {
                stringBuffer.append("if_icmpne" + this.branchLocation() + "\t\t  Branch if top two stack integers are not equal");
                break;
            }
            case 161: {
                stringBuffer.append("if_icmplt" + this.branchLocation() + "\t\t  Branch if top two stack integers are equal");
                break;
            }
            case 162: {
                stringBuffer.append("if_icmpge" + this.branchLocation() + "\t\t  Branch if top two stack integers are greater than or equal");
                break;
            }
            case 163: {
                stringBuffer.append("if_icmpgt" + this.branchLocation() + "\t\t  Branch if top two stack integers are greater than");
                break;
            }
            case 164: {
                stringBuffer.append("if_icmple" + this.branchLocation() + "\t\t  Branch if top two stack integers less than or equal");
                break;
            }
            case 165: {
                stringBuffer.append("if_acmpeq" + this.branchLocation() + "\t\t  Branch if top two stack objects are equal");
                break;
            }
            case 166: {
                stringBuffer.append("if_acmpne" + this.branchLocation() + "\t\t  Branch if top two stack objects are not equal");
                break;
            }
            case 167: {
                stringBuffer.append("goto" + this.branchLocation());
                break;
            }
            case 168: {
                stringBuffer.append("jsr " + this.branchLocation() + "\t\t\t   Execute subroutine");
                break;
            }
            case 169: {
                stringBuffer.append("ret" + this.enumBytes(1) + "\t\t\t\tReturn from subroutine (return address stored in vars[" + this.code[this.codepos - 1] + ']');
                break;
            }
            case 170: {
                stringBuffer.append("tableswitch");
                while (this.codepos % 4 != 0) {
                    ++this.codepos;
                }
                stringBuffer.append(" default:" + this.enumDwords(1));
                int n = this.getDword();
                int n2 = this.getDword();
                int n3 = n2 - n + 1;
                while (n3 != 0) {
                    this.codepos += 4;
                    --n3;
                }
                break;
            }
            case 171: {
                stringBuffer.append("lookupswitch");
                while (this.codepos % 4 != 0) {
                    ++this.codepos;
                }
                stringBuffer.append(" default:" + this.enumDwords(1));
                int n = this.getDword();
                while (n != 0) {
                    this.codepos += 4;
                    --n;
                }
                break;
            }
            case 172: {
                stringBuffer.append("ireturn\t\t\t\tReturn Integer on stack top");
                break;
            }
            case 173: {
                stringBuffer.append("lreturn\t\t\t\tReturn Long on stack top");
                break;
            }
            case 174: {
                stringBuffer.append("freturn\t\t\t\tReturn Float on stack top");
                break;
            }
            case 175: {
                stringBuffer.append("dreturn\t\t\t\tReturn Double on stack top");
                break;
            }
            case 176: {
                stringBuffer.append("areturn\t\t\t\tReturn Object on stack top");
                break;
            }
            case 177: {
                stringBuffer.append("return\t\t\t\t Return w/o object");
                break;
            }
            case 178: {
                stringBuffer.append("getstatic" + this.poolIndex(2) + "\t\t  Push contents of static field");
                break;
            }
            case 179: {
                stringBuffer.append("putstatic" + this.poolIndex(2) + "\t\t   Store stack top into static field");
                break;
            }
            case 180: {
                stringBuffer.append("getfield" + this.poolIndex(2) + "\t\t\tPush contents of field");
                break;
            }
            case 181: {
                stringBuffer.append("putfield" + this.poolIndex(2) + "\t\t\tStore stack top into field");
                break;
            }
            case 182: {
                stringBuffer.append("invokevirtual" + this.poolIndex(2));
                break;
            }
            case 183: {
                stringBuffer.append("invokenonvirtual" + this.poolIndex(2));
                break;
            }
            case 184: {
                stringBuffer.append("invokestatic" + this.poolIndex(2));
                break;
            }
            case 185: {
                stringBuffer.append("invokeinterface" + this.poolIndex(2));
                stringBuffer.append(this.enumBytes(1));
                ++this.codepos;
                break;
            }
            case 186: {
                stringBuffer.append("newfromname\t\t\tCreate a new Object using name on stack top");
                break;
            }
            case 187: {
                stringBuffer.append("new" + this.poolIndex(2) + "\t\t\t   Create a new Object on stack top");
                break;
            }
            case 188: {
                stringBuffer.append("newarray" + this.enumBytes(1) + "\t\t   Create a new array of type " + this.code[this.codepos - 1]);
                break;
            }
            case 189: {
                stringBuffer.append("anewarray" + this.poolIndex(2) + "\t\t\tAllocate a new array of Objects");
                break;
            }
            case 190: {
                stringBuffer.append("arraylength\t\t\tGet length of array on stack top");
                break;
            }
            case 191: {
                stringBuffer.append("athrow\t\t\t\t Throw exception at stack top");
                break;
            }
            case 192: {
                stringBuffer.append("checkcast" + this.poolIndex(2) + "\t\t  Verify cast against stack top Object");
                break;
            }
            case 193: {
                stringBuffer.append("instanceof" + this.poolIndex(2) + "\t\t Check instance of stack top Object");
                break;
            }
            case 194: {
                stringBuffer.append("monitorenter\t\t   Enter Thread Monitor");
                break;
            }
            case 195: {
                stringBuffer.append("monitorexit\t\t\tExit Thread Monitor");
                break;
            }
            case 196: {
                stringBuffer.append("wide" + this.enumBytes(1) + "\t\t   Next instruction uses a 16 bit index");
                break;
            }
            case 197: {
                stringBuffer.append("multianewarray" + this.poolIndex(2) + this.enumBytes(1) + " Allocate a multi dimensional array of dimension " + this.code[this.codepos - 1]);
                break;
            }
            case 198: {
                stringBuffer.append("ifnull 052\t\t\t Branch if stack top is NULL");
                stringBuffer.append("ifnull" + this.branchLocation() + "\t\t\t Branch if stack top is NULL");
                break;
            }
            case 199: {
                stringBuffer.append("ifnonnull" + this.branchLocation() + "\t\t  Branch if stack top is not NULL");
                break;
            }
            case 200: {
                stringBuffer.append("goto_w" + this.wbranchLocation());
                break;
            }
            case 201: {
                stringBuffer.append("jsr_w" + this.wbranchLocation());
                break;
            }
            case 202: {
                stringBuffer.append("breakpoint");
                break;
            }
            case 209: {
                stringBuffer.append("ret_w" + this.enumWords(1));
                break;
            }
            default: {
                stringBuffer.append("Unknown Byte Code " + this.code[this.codepos - 1]);
            }
        }
        return stringBuffer.toString();
    }

    protected String enumBytes(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 0) {
            stringBuffer.append(" " + this.code[this.codepos++]);
            --n;
        }
        return stringBuffer.toString();
    }

    protected String enumWords(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 0) {
            int n2 = 256 * this.code[this.codepos] + this.code[this.codepos + 1];
            stringBuffer.append(" " + n2);
            this.codepos += 2;
            --n;
        }
        return stringBuffer.toString();
    }

    protected String enumDwords(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 0) {
            int n2 = 0;
            n2 = this.code[this.codepos];
            n2 *= 256;
            n2 += this.code[this.codepos + 1];
            n2 *= 256;
            n2 += this.code[this.codepos + 2];
            n2 *= 256;
            stringBuffer.append(" " + (n2 += this.code[this.codepos + 3]));
            this.codepos += 4;
            --n;
        }
        return stringBuffer.toString();
    }

    protected int getDword() {
        int n = 0;
        n = this.code[this.codepos];
        n *= 256;
        n += this.code[this.codepos + 1];
        n *= 256;
        n += this.code[this.codepos + 2];
        n *= 256;
        this.codepos += 4;
        return n += this.code[this.codepos + 3];
    }

    protected String poolIndex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != 0) {
            n2 *= 256;
            n2 += this.code[this.codepos++];
            --n;
        }
        return " #" + n2 + " <" + this.constants.describe(n2) + '>';
    }

    protected String branchLocation() {
        int n = 0;
        n = this.code[this.codepos++] * 256;
        short s = (short)(n += this.code[this.codepos++]);
        s = (short)(s + (short)(this.codepos - 3));
        return " " + s;
    }

    protected String wbranchLocation() {
        int n = 0;
        n = this.code[this.codepos++] * 256;
        n += this.code[this.codepos++];
        n *= 256;
        n += this.code[this.codepos++];
        n *= 256;
        n += this.code[this.codepos++];
        return " " + (n += this.codepos - 5);
    }

    public ByteCodeInfo(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream) {
        this.constants = constantPoolInfo;
        try {
            this.code_length = dataInputStream.readInt();
            this.code = new int[this.code_length];
            int n = 0;
            while (n < this.code_length) {
                this.code[n] = dataInputStream.readUnsignedByte();
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("" + iOException);
        }
    }
}

