package grid.worker;

import grid.util.Defaults;
import java.awt.BorderLayout;
import javax.swing.JFrame;

public class App extends JFrame {
	private WorkerController wc;

	private static void printHelp() {
		System.out.println("Usage: grid.worker.App <server> <workers>");
	}
	
	public static void main(String args[]) {
		if(args.length > 0) {
			if(args[0].equalsIgnoreCase("--help")) {
				printHelp();
				return;
			}
			System.setProperty("grid.worker.Worker.server", args[0]);
		}
		if(args.length > 1) {
			try {
				Integer.parseInt(args[1]);
				System.setProperty("grid.worker.Worker.workers", args[1]);
			} catch (Exception e) {}
		}

		App a = new App();
		a.setVisible(true);
	}

	public App() {
		super(Defaults.version+" Worker Controller");
		wc = new WorkerController(this);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(wc, BorderLayout.CENTER);
		setSize(640, 480);

		addWindowListener(wc);
	}
}
