package grid.manager;

import javax.swing.table.AbstractTableModel;
import java.util.List;

public class JobTableModel extends AbstractTableModel {
	private Manager man;

	public JobTableModel(Manager man) {
		this.man = man;
		man.addScheduleListener(new JobAddHandler());
		man.addFinishListener(new JobFinishHandler());
		man.addStatusChangeListener(new JobStatusChangeHandler());
	}

	public int getRowCount() {
		return man.getJobCount();
	}

	public int getColumnCount() {
		return 3;
	}

	private static String columns[] = {
		"Job Name",
		"Status",
		"Worker"
	};

	public String getColumnName(int column) {
		return columns[column];
	}

	private static String stati[] = {
		"Waiting",
		"Processing",
		"Finished"
	};

	public Object getValueAt(int row, int column) {
		switch(column) {
			case 0:
				return man.getJobID(row);
			case 1:
				int x = man.getJobStatus(row);
				if(x == -1) return "Unknown";
				return stati[x];
			case 2:
				return man.getJobWorkerID(row);
			default:
				return "?";
		}
	}

	class JobAddHandler implements JobScheduleListener {
		public void jobScheduled(JobScheduleEvent jse) {
			int serials[] = jse.getJobSerials();
			int min = Integer.MAX_VALUE;
			int max = Integer.MIN_VALUE;

			for(int i = 0; i < serials.length; i++) {
				if(serials[i] < min) {
					min = serials[i];
				} else if(serials[i] > max) {
					max = serials[i];
				}
			}
			fireTableRowsInserted(min, max);
		}
	}

	class JobFinishHandler implements JobFinishListener {
		public void jobFinished(JobFinishEvent jfe) {
			int serials[] = jfe.getJobSerials();
			int min = 0;
			int max = 0;

			for(int i = 0; i < serials.length; i++) {
				if(serials[i] < min) {
					min = serials[i];
				} else if(serials[i] > max) {
					max = serials[i];
				}
			}

			try {
				fireTableRowsDeleted(min, max);
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("min "+min+" max "+max);
			}
		}
	}

	class JobStatusChangeHandler implements JobStatusChangeListener {
		public void jobStatusChanged(JobStatusChangeEvent jsce) {
			int x = man.getJobNumber(jsce.getJobID());
			fireTableRowsUpdated(x, x);
		}
	}
}
