package grid.manager;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import java.util.List;
import java.util.LinkedList;

public class JobController extends JPanel implements WindowListener {
	private JTable jobsTable;
	private JButton exitButton;
	private JobTableModel jtm;
	private List jobList;
	private Manager manager;
	private Frame frame;
	
	public JobController(Manager man) {
		this.manager = man;
		init();
	}

	public JobController(Manager man, Frame frame) {
		this.manager = man;
		this.frame = frame;
		init();
	}

	public void init() {
		//set up UI elements
		jtm = new JobTableModel(manager);
		jobsTable = new JTable(jtm);
		exitButton = new JButton("Exit");
		exitButton.setMnemonic('x');

		//lay out components
		GridBagLayout gb = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();

		setLayout(gb);
		
		c.insets = new Insets(10, 10, 10, 10);
		c.fill = GridBagConstraints.BOTH;
		c.gridx = 0;
		c.gridy = 1;
		c.weighty = 1.0;
		c.weightx = 1.0;
		c.gridwidth = 4;
		JScrollPane jsp = new JScrollPane(jobsTable);
		gb.setConstraints(jsp, c);
		add(jsp);

		if(frame != null) {
			c.fill = GridBagConstraints.HORIZONTAL;
			c.gridx = 3;
			c.gridy = 2;
			c.weighty = 0.0;
			c.weightx = 1.0;
			c.gridwidth = 1;
			gb.setConstraints(exitButton, c);
			add(exitButton);
		}

		JLabel x;
		c.gridx = 2;
		x = new JLabel("");
		gb.setConstraints(x, c);
		add(x);
		c.gridx = 1;
		x = new JLabel("");
		gb.setConstraints(x, c);
		add(x);
		c.gridx = 0;
		x = new JLabel("");
		gb.setConstraints(x, c);
		add(x);

		x = new JLabel("Current Jobs:");
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 4;
		gb.setConstraints(x, c);
		add(x);

		//set up action events
		exitButton.addActionListener(new ExitHandler());
	}

	public void windowActivated(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowClosing(WindowEvent e) {
		System.exit(0);
	}
	public void windowDeactivated(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}

	class ExitHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			frame.dispose();
		}
	}
}
