package grid.client;

import grid.util.Defaults;
import grid.manager.Job;
import grid.manager.ClientManager;
import grid.manager.JobFinishedCallback;
import grid.worker.TaskWorker;
import grid.Workable;
import java.util.Map;
import java.util.HashMap;
import java.rmi.Naming;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/**
 * This is a basic grid client.  It connects to the manager, sends it a
 * few jobs to chew on, and then waits for them to come back.  It shows you
 * a progress screen and exits when all tasks are finished.
 */
public class TrivialClient extends UnicastRemoteObject implements JobFinishedCallback, Serializable {
	public static void main(String args[]) throws Exception {
		if(args.length < 2) {
			System.out.println("Usage: grid.client.TrivialClient <manager> <jobs>");
			return;
		}

		String host = args[0];
		int jobs = Integer.parseInt(args[1]);

		System.setSecurityManager( new java.rmi.RMISecurityManager() );
		TrivialClient tc = new TrivialClient(host, jobs);
		tc.engage();
	}

	private String host;
	private int jobs;
	private Map jz;

	public TrivialClient(String host, int jobs) throws RemoteException {
		super();
		this.host = host;
		this.jobs = jobs;
		jz = new HashMap();
	}

	public void engage() {

		String name = "//"+host+"/"+Defaults.managerService;
		ClientManager cm = null;
		try {
			cm = (ClientManager) Naming.lookup(name);
		} catch (Exception e) {
			System.err.println("Unable to find manager at "+host+"!  Aborting.");
			System.err.println(e.getMessage());
			return;
		}

		System.out.println("Submitting "+jobs+" jobs...");
		try {
			for(int i = 0; i < jobs; i++ ) {
				Job j = new Job(new TrivialWork(i), "trivial-"+i, this, 10000);
				cm.scheduleJob(j);
				jz.put("trivial-"+i, j);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}

		while(!jz.isEmpty()) {
			try {
				Thread.sleep(1000);
				System.out.println(jz.size());
			} catch (Exception e) {}
		}
		System.exit(0);
	}


	public void jobFinished(String jobID, Object result) {
		Job j = (Job)jz.get(jobID);
		if(j == null) {System.out.println("bogus finished job: "+jobID); return;}
		System.out.println("in: "+((TrivialWork)j.work).getInput()+" => "+result);
		jz.remove(jobID);
		//jz.notify();
	}
}

// XXX: The job should be in a different file!
class TrivialWork implements Workable {
	private int in;

	public TrivialWork(int in) {
		this.in = in;
	}

	public int getInput() {
		return in;
	}

	public Object execute(TaskWorker control) {
		System.out.println("Processing "+in);
		for(int i = 0; i < 20 && control.shouldProceed(); i++) {
			try {
				Thread.sleep(500);
			} catch (Exception e) {}
		}

		if(control.shouldProceed() == false) {
			System.out.println("Oh! Aborted! Bye!");
			return null;
		}

		System.out.println("I computed that " + in + " + 1 = " + (in+1) );
		return new Integer(in+1);
	}
}
