import java.awt.*;
import java.util.*;
import java.net.*;
import java.io.*;
import javax.swing.text.html.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.event.*;

public class InetUtils extends JApplet implements WindowListener, ActionListener, Runnable {
	private JEditorPane ep;
	private JTextField tfServer, tfURL, tfPort, tfOutput;
	private StringBuffer sb;
	private HTMLEditorKit htmlKit;
	private JIPAddress iaStartAddress, iaStopAddress;

	public static void main(String args[]) {
		JFrame f = new JFrame("Internet Utilities");
		InetUtils iu = new InetUtils();
		f.addWindowListener(iu);

		Container c = f.getContentPane();
		c.setLayout(new BorderLayout());
		c.add("Center", iu);

		setProperWindowSize(f);
		f.setVisible(true);
	}

	private static void setProperWindowSize(Window w) {
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		w.setSize((d.width * 3) / 4, (d.height * 3) / 4);
		Dimension b = w.getSize();
		w.setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
	}

	public InetUtils() {
		super();
		ep = new JEditorPane();

		JTabbedPane tp = new JTabbedPane();

		//construct the find ips panel
		JPanel pFindIPs = new JPanel();
		pFindIPs.setLayout(new BorderLayout());
		JLabel l = new JLabel(" Enter server name: ", SwingConstants.RIGHT);
		pFindIPs.add("West", l);
		tfServer = new JTextField("submarine.dyndns.org");
		pFindIPs.add("Center", tfServer);
		JButton b = new JButton("Find IPs!");
		b.setActionCommand("FindIPs");
		b.addActionListener(this);
		pFindIPs.add("East", b);
		tp.addTab("Find IP Addresses", pFindIPs);

		//construct the http requests panel
		JPanel pHTTPRequest = new JPanel();
		pHTTPRequest.setLayout(new BorderLayout());
		l = new JLabel(" Enter URL: ", SwingConstants.RIGHT);
		pHTTPRequest.add("West", l);
		tfURL = new JTextField("http://submarine.dyndns.org/~djwong/");
		pHTTPRequest.add("Center", tfURL);
		b = new JButton("Fetch!");
		b.setActionCommand("FetchURL");
		b.addActionListener(this);
		pHTTPRequest.add("East", b);
		tp.addTab("HTTP Requests", pHTTPRequest);

//	   JPanel pFingerRequest = new JPanel();
//	   tp.addTab("Finger Requests", pFingerRequest);

//	   JPanel pHTTPScanner;

		JPanel pHttpScanner = new JPanel();
		pHttpScanner.add(new JLabel("Scan from: "));
		iaStartAddress = new JIPAddress("192.168.1.0");
		pHttpScanner.add(iaStartAddress);

		pHttpScanner.add(new JLabel(" to "));
		iaStopAddress = new JIPAddress("192.168.1.8");
		pHttpScanner.add(iaStopAddress);

		pHttpScanner.add(new JLabel(" on port "));
		tfPort = new JTextField("80", 4);
		Font f = new Font("Courier", Font.BOLD, 14);
		tfPort.setFont(f);
		pHttpScanner.add(tfPort);

		pHttpScanner.add(new JLabel(" and put output in "));
		tfOutput = new JTextField("./output/");
		f = new Font("Courier", Font.BOLD, 14);
		tfOutput.setFont(f);
		pHttpScanner.add(tfOutput);

		b = new JButton("Scan!");
		b.setActionCommand("HttpScanPorts");
		b.addActionListener(this);
		pHttpScanner.add(b);
		tp.addTab("HTTP Port Scanner", pHttpScanner);

		Container c = getContentPane();
		c.setLayout(new BorderLayout());
		c.add("Center", new JScrollPane(ep));
		c.add("North", tp);

		JMenuBar mb = new JMenuBar();

		JMenu mFile = new JCoolMenu("File");
		JMenuItem mi = new JMenuItem("Exit", 'x');
		mi.setActionCommand("FileExit");
		mi.addActionListener(this);
		mFile.add(mi);
		mFile.setMnemonic('F');
		mb.add(mFile);

		mFile = new JCoolMenu("Edit");
		mi = new JMenuItem("Clear", 'C');
		mi.setActionCommand("EditClear");
		mi.addActionListener(this);
		mFile.add(mi);
		mFile.setMnemonic('E');	   
		mb.add(mFile);

		setJMenuBar(mb);

		htmlKit = new HTMLEditorKit();
		ep.setEditorKit(htmlKit);
		ep.setEditable(false);

		sb = new StringBuffer();
	}

	//WindowListener
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowClosing(WindowEvent e) {System.exit(0);}

	private int iCurrentFunction = 0;
	//0 = none
	//1 = find ip
	//2 = http request
	//3 = port scan

	public void run() {
	  try {
		tfServer.setEnabled(false);
		tfURL.setEnabled(false);
		tfPort.setEnabled(false);
		iaStartAddress.setEnabled(false);
		iaStopAddress.setEnabled(false);
		tfOutput.setEnabled(false);

		switch(iCurrentFunction) {
			case 1: OnFindIPs(); break;
			case 2: OnHttpRequest(); break;
			case 3: OnHttpScan(); break;
		}
	  } finally {
		iCurrentFunction = 0;
		tfServer.setEnabled(true);
		tfURL.setEnabled(true);
		tfPort.setEnabled(true);
		iaStartAddress.setEnabled(true);
		iaStopAddress.setEnabled(true);
		tfOutput.setEnabled(true);
	  }
	}

	public void actionPerformed(ActionEvent e) {
		if(iCurrentFunction != 0) return; //if we're processing, ignore...

		String cmd = e.getActionCommand();
		if(cmd.equals("FileExit")) {
			System.exit(0);
		} else if(cmd.equals("EditClear")) {
			OnEditClear();
		} else if(cmd.equals("FindIPs")) {
			iCurrentFunction = 1;
			Thread t = new Thread(this);
			t.setDaemon(true);
			t.start();
		} else if(cmd.equals("FetchURL")) {
			iCurrentFunction = 2;
			Thread t = new Thread(this);
			t.setDaemon(true);
			t.start();
		} else if(cmd.equals("HttpScanPorts")) {
			iCurrentFunction = 3;
			Thread t = new Thread(this);
			t.setDaemon(true);
			t.start();
		}
		SetConsoleContents(sb.toString());
	}

	private void OnEditClear() {
		sb = new StringBuffer();
		try {
			BufferedReader in = new BufferedReader(new StringReader(sb.toString()));
			Document d = htmlKit.createDefaultDocument();
			htmlKit.read(in, d, 0);
			ep.setDocument(d);
		} catch (Exception ex) {ex.printStackTrace();}
	}

	private void OnFindIPs() {
		InetAddress inetAddr, inetAddrs[];
		int i;

		try {
			sb.append("<H1>Find IP Addresses</H1>\n");
			inetAddr = InetAddress.getLocalHost();
			sb.append("Local System: ");
			sb.append(inetAddr +"<BR>\n");
			// print out hostname and IP address of local host
			inetAddr = InetAddress.getByName(tfServer.getText());
			// create an InetAddress object from a given hostname
			sb.append(inetAddr.getHostName() + ":\n");
			sb.append("<BR>Looking up: " + inetAddr+"<BR>\n");
			// print out hostname and IP address in inetAddr
			sb.append("<BR>Additional addresses:<BR>\n");
			inetAddrs = InetAddress.getAllByName(tfServer.getText());
			// get all addresses associated with a give hostname
			for (i=1; i < inetAddrs.length; i++) {
				// loop through printing out all addresses
				sb.append("   " + inetAddrs[i]+"<BR>\n");
			}
			if(i == 1) {
				sb.append("There are no additional addresses.\n");
			}
			sb.append("<BR>Done.\n");
		} catch (UnknownHostException x) {
			// handle unknown host exceptions
			sb.append("<BR>ERROR: Hostname cannot be resolved.  Hostname = " + tfServer.getText()+"\n");
		} catch (Exception y) {
			sb.append("<BR>ERROR: Your browser is not set up to allow connections to other computers.  You can either enable this priviledge or run FindIPs as a Java Application.");
		}
		SetConsoleContents(sb.toString());
	}

	private void SetConsoleContents(String x) {
		try {
			BufferedReader in = new BufferedReader(new StringReader(x));
			Document d = htmlKit.createDefaultDocument();
			htmlKit.read(in, d, 0);
			ep.setDocument(d);
		} catch (Exception ex) {ex.printStackTrace();}
	}

	private void OnHttpRequest() {
		try {
			URL earl = new URL(tfURL.getText());

			sb.append("<H1>Get HTTP Request</H1>\n");
			sb.append("Getting URL \""+earl+"\"...<BR>");
			sb.append("Response:<B><br>");

			String server = earl.getHost();
			int port = earl.getPort();
			if(port < 0) port = 80;
			String ref = earl.getFile();

			Socket client = new Socket(server, port);

			DataOutputStream outbound = new DataOutputStream(client.getOutputStream() );
			BufferedReader inbound = new BufferedReader(new InputStreamReader(client.getInputStream()) );

			outbound.writeBytes("GET "+ref+" HTTP/1.0\r\n\r\n");

			SetConsoleContents(sb.toString());

			// Read the response
			String responseLine, temp, result;
			StringTokenizer st;
			while ((responseLine = inbound.readLine()) != null) {
				st = new StringTokenizer(responseLine, "<>", true);
				result = "";
				while(st.hasMoreTokens()) {
					temp = st.nextToken();
					if(temp.equals("<")) result += "&lt;";
					else if(temp.equals(">")) result += "&gt;";
					else result += temp;
				}
				sb.append(result + "<BR>\n");
			}
			sb.append("</b>");
		} catch (Exception ex) {
			sb.append(ex.getLocalizedMessage()+".<br>");
		}
		SetConsoleContents(sb.toString());
	}

	private void OnHttpScan() {
		long start = iaStartAddress.getAddressAsLong();
		long end = iaStopAddress.getAddressAsLong();
		int port = Integer.parseInt(tfPort.getText());
		if((port < 0) || (port > 65535)) port = 80;

		sb.append("<H1>HTTP Scan</H1>\n");

		String ip;
		String outt = tfOutput.getText();
		for(long i = start; i <= end; i++) {
		  try {
			ip = IPAddressUtils.getLongAsString(i);
			String earl = "http://"+ip+":"+port+"/";
			String out = outt + ip+"_"+port+".html";
			sb.append("Now trying "+earl+"...<br>");
			SetConsoleContents(sb.toString());
			URL sourceurl = new URL(earl);

			//open connection
			URLConnection sourceurlc = sourceurl.openConnection();
			sourceurlc.connect();
			InputStream remotefileis = sourceurlc.getInputStream();

			 //now construct URL
			sb.append("Copying "+earl+" to "+out+"...<br>");

			//now get the local file...
			OutputStream localfileos = new FileOutputStream(out);

			copyFile(sourceurlc.getContentLength(), remotefileis, localfileos);
			localfileos.flush();
			localfileos.close();
		  } catch (Exception ex) {
			sb.append(ex.getLocalizedMessage()+".<br>");
		  }
		  sb.append("</b><br>");
		  SetConsoleContents(sb.toString());
		}
	}

	private void copyFile(int length, InputStream i, OutputStream o) throws Exception {
		int in, read = 0;

		do {
			in = i.available();
			if(in < 1) continue;
			read += in;
			byte[] b = new byte[in];
			i.read(b);
			o.write(b);
		} while (read < length);

		i.close();
		o.close();
	}
}
