import java.util.*;

public class IPAddressUtils {
   public static String getLongAsString(long x) {
       long p1 = (x & 0xFF000000) >> 24;
       long p2 = (x & 0x00FF0000) >> 16;
       long p3 = (x & 0x0000FF00) >> 8;
       long p4 = (x & 0x000000FF);

       return (p1+"."+p2+"."+p3+"."+p4);
   }

   public static long getStringAsLong(String x) {
       StringTokenizer st = new StringTokenizer(x, ".", false);

       long part1 = Long.parseLong( truncate(st.nextToken()) );
       long part2 = Long.parseLong( truncate(st.nextToken()) );
       long part3 = Long.parseLong( truncate(st.nextToken()) );
       long part4 = Long.parseLong( truncate(st.nextToken()) );

       return (part1 << 24) + (part2 << 16) + (part3 << 8) + (part4);
   }

   public static String truncate(String in) {
       if(in.length() > 3) in = in.substring(0, 2);
       int x = Integer.parseInt(in);
       if(x > 255) x = 255;
       return Integer.toString(x);
   }
}