#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include <stdio.h>

void gauss(double eqs[], double sol[], int N) {
   double temp;
   int i, j, k, max, r;

   r = N+1;

   //first do triangulation

   for(i=0;i<N;i++) {
       max = i;
       for(j=i+1;j<N;j++)
           if( fabs(eqs[j*r+i]) > fabs(eqs[max*r+i]) ) max = i;
       for(k=i;k<N+1;k++) {
           temp=eqs[i*r+k];
           eqs[i*r+k] = eqs[max*r+k];
           eqs[max*r+k] = temp;
       }

       for(j=i+1;j<N;j++) {
           for(k=N;k>=i;k--) {
               eqs[j*r+k] = eqs[j*r+k] - eqs[i*r+k] * eqs[j*r+i] / eqs[i*r+i];
           }
       }
   }

   //now do the back substitution

   for(j=N-1;j>=0;j--) {
       temp=0;
       for(k=j+1; k<N; k++)
           temp += eqs[j*r+k] * sol[k];
       sol[j] = (eqs[j*r+N] - temp) / eqs[j*r+j];
   }
}
/*
#define width 6
#define height 5

void main(void) {
   double equations[height][width] = {
       1.0,  3.0, -4.0,  8.0,  2.7, -5.3,
       1.0,  1.0, -2.0,  2.0,  4.2, -9.6,
      -1.0, -2.0,  5.0, -1.0,  -27.9, 3.4,
      11.0, -1.0, 32.0,  2.0,  6.2, -3.6,
       1.0,  7.0,  5.2, -1.1,  -2.9, 6.4,
   };

   double solution[height];
   int i, j;

   printf("\nMatrix:\n");

   for(i=0;i<height;i++) {
       for(j=0;j<width;j++) {
           printf("%8.3f", equations[i][j]);
       }
       printf("\n");
   }

   gauss(equations, solution, height);
   printf("Solution:\n");
   for(i=0;i<height;i++) printf("var %d = %8.3f\n", i, solution[i]);
}
*/

void main(void) {
   int width, height;
   cout << "Enter # of cols: ";
   cin >> width;
   cout << "Enter # of rows: ";
   cin >> height;

   double *equations = (double *)malloc(sizeof(double) * width * height);
   double *solution = (double *)malloc(sizeof(double) * height);

   double *ptr = equations;
   int i = 0, j;
   int dim = width * height;

   for(i; i<dim; i++,ptr++) {
//       cout << "Enter item " << i << ": ";
       cout << "Enter item " << (i/width)+1 << "," << (i%width)+1 << ": ";       
       cin >> *ptr;
   }

   ptr = equations;

   cout << "Going in:" << endl;
   printf("Matrix:\n");
   for(i=0;i<height;i++) {
       for(j=0;j<width;j++) {
           printf("%8.3f", *ptr);
           ptr++;
       }
       printf("\n");
   }

   gauss(equations, solution, height);

   printf("Solutions:\n");
   ptr = solution;
   for(i=0;i<height;i++,ptr++) printf("var %d = %8.3f\n", i, *ptr);

   free(equations);
   free(solution);
}

