import java.io.*;
import java.util.*;
import java.net.*;

public class BackTalk {
   private int iPort = 80;
   private String sJobFile = "http://thibs.menloschool.org/~bean/print/jobs.txt";
   private static final int bufsize = 8192;
   private Vector v;
   private static final boolean fastcopy = false;
   private String sLogFile;

   private static final String prodLong = "BackTalk 1.34 by Seor Bean";
   private static final String prodShort = "BackTalk1.34";

   public static void main(String args[]) {
       BackTalk b = new BackTalk(args);
   }

   public static void displaySyntax() {
       System.err.println(prodLong+": Remote script processor.  Put it on a task scheduler!");
       System.err.println("Run stuff overnight...so I can send my 100 page print jobs without worry.");
       System.err.println("Best with a regularly scheduled task scheduler.  (cron, mstask, etc.)");
       System.err.println("");
       System.err.println("java BackTalk [sJobFile]");
       System.err.println("");
       System.err.println("  sJobFile URL  Specifies job script to read commands from.  It can be a URL or");
       System.err.println("                a file path.  Default: http://thibs.menloschool.org/~bean/print");
       System.err.println("                /jobs.txt.  Logs are dumped to the \"l_\" + the file's name, e.g.");
       System.err.println("                ./l_jobs.txt.");
       System.err.println("");
       System.err.println("Job script format:  Put any of these commands in a text file.");
       System.err.println("");
       System.err.println("  COPYFILE source dest -- Copies source to dest.");
       System.err.println("  DELETE file -- Deletes file");
       System.err.println("  DOWNLOAD fileURL localfile -- Downloads fileURL to localfile.");
       System.err.println("  EXEC command -- Executes command as a native process.");
       System.err.println("  MAILFILE filetomail smtp rcpt -- Sends filetomail to rcpt via smtp.");
       System.err.println("  MAILLOG smtp rcpt -- Sends log to rcpt via smtp.");
       System.err.println("  MAILURL urltomail smtp rcpt -- Sends urltomail to rcpt via smtp.");
       System.err.println("  MKDIR folder -- Creates folder (and any parent folders necessary.");
       System.err.println("  PRINTFILE file printer port -- Prints file to printer on port \"port\".");
       System.err.println("  PRINTURL fileURL printer port -- Prints fileURL to printer on port \"port\".");
       System.err.println("  SLEEP time -- Sleeps for time ms.");
       System.err.println("  TOUCHFILE file -- Downloads file to a bit bucket.");
       System.err.println("  TOUCHURL URL -- Downloads URL to a bit bucket.");
   }

   private String strip(String x) {
       //this gets the supposed filename...
       int y = 0;
       if( (y = x.lastIndexOf('/')) != -1) {
           return x.substring(y+1, x.length());
       } else if( (y = x.lastIndexOf('\\')) != -1) {
           return x.substring(y+1, x.length());
       }
       return x;
   }

   public BackTalk(String args[]) {
       //First, read the config file...
       v = new Vector();
       try {
           FileInputStream fis = new FileInputStream("config.txt");
           Properties config = new Properties();
           config.load(fis);
           sJobFile = config.getProperty("sJobFile", "http://thibs.menloschool.org/~bean/print/jobs.txt");
           fis.close();
       } catch (Exception e) {}

       int j = args.length;
       int i = 0;
       while(i < j) {
           String s = args[i];
           if(s.equals("-?")) {
               displaySyntax(); return;
           } else if(s.equals("/?")) {
               displaySyntax(); return;
           } else {
               String x = args[i];
               try {
                   URL u = new URL(x);
                   sJobFile = x;
               } catch (Exception e) {
                   try {
                       sJobFile = GetFileAsURL(x);
                   } catch (Exception ex) {
                       ex.printStackTrace();
                       sJobFile = "http://thibs.menloschool.org/~bean/print/jobs.txt";
                   }
               }
           }
	        i++;
       }

       //create the log file...
       try {
           File f = new File("l_"+strip(sJobFile));
           sLogFile = f.getCanonicalPath();

           OutputStream logos = new FileOutputStream("l_"+strip(sJobFile));
           System.setOut(new PrintStream(logos));
           System.setErr(new PrintStream(logos));
       } catch (Exception e) {}

       System.out.println(prodLong);
       System.out.println("Read default config from config.txt.");       
       System.out.println("\r\nStarted batch processing at "+(new Date().toString()));
       long start = System.currentTimeMillis();
       System.out.println("Reading job from \""+sJobFile+"\"...");
       start();
       System.out.println("Finished batch processing at "+(new Date().toString()));
       System.out.println("Processing took "+(System.currentTimeMillis() - start)+"ms.");
       System.exit(0);
   }

   public String GetFileAsURL(String name) throws MalformedURLException, IOException {
       File f = new File(name);
       String path = f.getAbsolutePath();
       if (File.separatorChar != '/')
           path = path.replace(File.separatorChar, '/');

       if (!path.startsWith("/"))
           path = "/" + path;

       if (!path.endsWith("/") && f.isDirectory())
           path = path + "/";

       return new URL("file", "", path).toString();
   }

   private void start() {
       //First, retrieve the job description file.
       try {
           URL earl = new URL(sJobFile);
           URLConnection earlc = earl.openConnection();
           earlc.connect();
           InputStream is = earlc.getInputStream();

       if(fastcopy) {
           //copy cmds into a vector
           BufferedReader inbound = new BufferedReader(new InputStreamReader(is) );
           String responseLine;
           while ((responseLine = inbound.readLine()) != null)
               v.addElement(responseLine);
       } else {
           int in, read = 0, length = earlc.getContentLength();
           ByteArrayOutputStream baos = new ByteArrayOutputStream(length);

           do {
               in = is.available();
               if(in < 1) continue;
               read += in;
               byte[] b = new byte[in];
               is.read(b);
               baos.write(b, 0, in);
           } while (read < length);

           is.close();
           baos.close();
           String cmds = new String(baos.toByteArray());
           StringTokenizer lines = new StringTokenizer(cmds, "\r\n", false);
           String cmd;
           while(lines.hasMoreTokens()) {
               cmd = lines.nextToken();
               if(cmd.equals("")) continue;
               v.addElement(cmd);
           }
       }
           System.out.println("----------------");
           is.close();
           //get an enumeration
           Enumeration enu = v.elements();
           //run thru elements
           int x = 0;
           String cmd;
           while(enu.hasMoreElements()) {
               //get the command
               cmd = (String)enu.nextElement();
               System.out.println("Command: \""+cmd+"\"");
               //parse the command
               StringTokenizer st = new StringTokenizer(cmd, " ", false);
               try {
                   String word = st.nextToken().toLowerCase();
                   if(word.equals("download")) {
                       cmdDownload(st, earl);
                   } else if(word.equals("printurl")) {
                       cmdPrintUrl(st, earl);
                   } else if(word.equals("mkdir")) {
                       cmdMkDir(st, earl);
                   } else if(word.equals("exec")) {
                       cmdExec(st, earl);
                   } else if(word.equals("delete")) {
                       cmdDelete(st, earl);
                   } else if(word.equals("mailfile")) {
                       cmdMailFile(st, earl);
                   } else if(word.equals("mailurl")) {
                       cmdMailUrl(st, earl);
                   } else if(word.equals("sleep")) {
                       cmdSleep(st, earl);
                   } else if(word.equals("printfile")) {
                       cmdPrintFile(st, earl);
                   } else if(word.equals("copyfile")) {
                       cmdCopyFile(st, earl);
                   } else if(word.equals("touchfile")) {
                       cmdTouchFile(st, earl);
                   } else if(word.equals("touchurl")) {
                       cmdTouchUrl(st, earl);
                   } else if(word.equals("maillog")) {
                       cmdMailLog(st, earl);
                   } else {
                       char first = word.charAt(0);
                       switch(first) {
                           case '#':
                           case ';':
                           case '/':break;
                           default: System.out.println("Unrecognized Command.");
                       }

                   }
                   System.out.flush();
               } catch (Throwable t) {
                   System.err.print("EXCEPTION: ");
                   t.printStackTrace();
               }
               System.out.println("----------------");
           }

       } catch (Exception e) {e.printStackTrace();}
   }

   private void cmdSleep(StringTokenizer st, URL jobfile) throws Exception {
       int wait = Integer.parseInt(st.nextToken());
       System.out.println("SLEEP: Sleeping for "+wait+"ms...");
       Thread.sleep(wait);
       System.out.println("SLEEP: Slept for "+wait+"ms...");
   }

   private void cmdMkDir(StringTokenizer st, URL jobfile) throws Exception {
       String foldername = unditchSpaces(st.nextToken());
       File f = new File(foldername);
       boolean x = f.mkdirs();
       System.out.println("MKDIR: Returned "+x);
   }

   private void cmdDelete(StringTokenizer st, URL jobfile) throws Exception {
       String foldername = unditchSpaces(st.nextToken());
       File f = new File(foldername);
       System.out.println("DELETE: Returned "+f.delete());
   }

   private void cmdExec(StringTokenizer st, URL jobfile) throws Exception {
       String foldername = unditchSpaces(st.nextToken());
       System.out.println("EXEC: Running \""+foldername+"\"...");
       Process p = Runtime.getRuntime().exec(foldername);
       System.out.println("EXEC: Returned "+p);
       p.waitFor();
   }

   private void cmdCopyFile(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String source = unditchSpaces(st.nextToken());
       String dest = unditchSpaces(st.nextToken());

       System.out.println("COPYFILE: Trying to copy "+source+" to "+dest+"...");

       File f = new File(source);
       InputStream sourceis = new FileInputStream(source);
       OutputStream destos = new FileOutputStream(dest);

       System.out.println("COPYFILE: Copying...");
       copyFile((int)f.length(), sourceis, destos);

       System.out.println("COPYFILE: Closing streams...");
       destos.flush();
       destos.close();
       destos.close();
       sourceis.close();
       System.out.println("COPYFILE: File copied.");
   }

   private static String translateDNS(String addr) {
       String newaddr = addr.toLowerCase();

       if(newaddr.equals("library1")) {
           return "172.20.9.199";
//       } else if(newaddr.equals("library2")) {
//           return "172.20.9.207";
       } else if(newaddr.equals("mmr")) {
           return "172.20.9.204";
       } else if(newaddr.equals("langlab")) {
           return "172.20.9.82";
       } else if(newaddr.equals("color")) {
           return "172.20.9.223";
       } else if(newaddr.equals("beanery")) {
           return "172.20.8.204";
       } else if(newaddr.equals("yearbook")) {
           return "172.20.9.91";
       } else if(newaddr.equals("loopback")) {
           return "127.0.0.1";
       } else {
           return addr;
       }
   }

   private void cmdPrintFile(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String filetoprint = unditchSpaces(st.nextToken());
       String sPrinterIP = (st.nextToken());
       int port = Integer.parseInt(st.nextToken());

       System.out.println("PRINTFILE: Trying to print "+filetoprint+" to "+sPrinterIP+":"+port+"...");

       sPrinterIP = translateDNS(sPrinterIP);

       File f = new File(filetoprint);

       //now get the local file...
       InputStream localfileis = new FileInputStream(filetoprint);

       //now get the local file...
       //this is the Menlo-specific version.
       //Hopefully the printer IP doesn't change...
       //better yet, set an option for the config file...later?

       boolean gotConnection = false;
       Socket printsock = null;
       OutputStream printos = null;
       System.out.println("PRINTFILE: Trying to open "+sPrinterIP+":"+port+"...");
       do {
           try {
       	    printsock = new Socket(sPrinterIP, port);
               gotConnection = true;
           } catch (java.net.ConnectException e) {
               System.out.println("PRINTFILE: Connection refused, will try again in 10s..");
               gotConnection = false;
               try { Thread.sleep(10000); } catch (InterruptedException ez) {}
           }
       } while( (gotConnection == false) || (printsock == null) );
       System.out.println("PRINTFILE: Connected to printer @ "+sPrinterIP+":"+port+".  Sending file...");
       printos = printsock.getOutputStream();

       System.out.println("PRINTFILE: Printing...");
       copyFile((int)f.length(), localfileis, printos);

       System.out.println("PRINTFILE: Closing streams...");
       printos.flush();
       printos.close();
       printsock.close();
       localfileis.close();
       System.out.println("PRINTFILE: File sent to printer.");
   }

   private void cmdMailFile(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String filetomail = unditchSpaces(st.nextToken());
       String sSmtpServer = unditchSpaces(st.nextToken());
       String sSendToWhom = st.nextToken();

       sSmtpServer = translateDNS(sSmtpServer);

       System.out.println("MAILFILE: Trying to mail "+filetomail+" to "+sSmtpServer+":25...");

       boolean gotConnection = false;
       Socket smtpsocket = null;
       System.out.println("MAILFILE: Trying to open SMTP server "+sSmtpServer+":25...");
       do {
           try {
       	    smtpsocket = new Socket(sSmtpServer, 25);
               gotConnection = true;
           } catch (java.net.ConnectException e) {
               System.out.println("MAILFILE: Connection refused, will try again in 10s..");
               gotConnection = false;
               try { Thread.sleep(10000); } catch (InterruptedException ez) {}
           }
       } while( (gotConnection == false) || (smtpsocket == null) );
       System.out.println("MAILFILE: Connected to SMTP server @ "+sSmtpServer+":25.  Mailing file...");
       OutputStream smtpos = smtpsocket.getOutputStream();

       File f = new File(filetomail);

       //now get the local file...
       InputStream localfileis = new FileInputStream(filetomail);

       String command = "HELO "+InetAddress.getLocalHost().getHostAddress()+"\nMAIL FROM: "+prodShort+"@"+InetAddress.getLocalHost().getHostName()+"\nRCPT TO: "+sSendToWhom+"\nDATA\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILFILE: Copying...");
       command = "Subject: BackTalk mail: "+filetomail+"\nOn "+(new Date())+", BackTalk was instructed to send the file\n"+filetomail+"\nfrom "+InetAddress.getLocalHost().getHostName()+" / "+InetAddress.getLocalHost().getHostAddress()+"!\nHere is the file:\n\n";
       smtpos.write(command.getBytes());
       copyFileNoClose((int)f.length(), localfileis, smtpos);

       System.out.println("MAILFILE: Sent...");
       command = "\n.\nQUIT\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILFILE: Closing streams...");
       smtpos.flush();
       smtpos.close();
       localfileis.close();
       System.out.println("MAILFILE: Done mailing.");
   }

   private void cmdMailLog(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String filetomail = sLogFile;
       String sSmtpServer = unditchSpaces(st.nextToken());
       String sSendToWhom = st.nextToken();

       sSmtpServer = translateDNS(sSmtpServer);

       System.out.println("MAILLOG: Trying to mail log "+filetomail+" to "+sSmtpServer+":25...");

       boolean gotConnection = false;
       Socket smtpsocket = null;
       System.out.println("MAILLOG: Trying to open SMTP server "+sSmtpServer+":25...");
       do {
           try {
       	    smtpsocket = new Socket(sSmtpServer, 25);
               gotConnection = true;
           } catch (java.net.ConnectException e) {
               System.out.println("MAILLOG: Connection refused, will try again in 10s..");
               gotConnection = false;
               try { Thread.sleep(10000); } catch (InterruptedException ez) {}
           }
       } while( (gotConnection == false) || (smtpsocket == null) );
       System.out.println("MAILLOG: Connected to SMTP server @ "+sSmtpServer+":25.  Mailing file...");
       OutputStream smtpos = smtpsocket.getOutputStream();

       File f = new File(filetomail);

       //now get the local file...
       InputStream localfileis = new FileInputStream(filetomail);

       String command = "HELO "+InetAddress.getLocalHost().getHostAddress()+"\nMAIL FROM: "+prodShort+"@"+InetAddress.getLocalHost().getHostName()+"\nRCPT TO: "+sSendToWhom+"\nDATA\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILLOG: Copying...");
       command = "Subject: BackTalk log: "+filetomail+"\nOn "+(new Date())+", BackTalk was instructed to send the log\n"+filetomail+"\nfrom "+InetAddress.getLocalHost().getHostName()+" / "+InetAddress.getLocalHost().getHostAddress()+"!\nHere is the file:\n\n";
       smtpos.write(command.getBytes());
       copyFileNoClose((int)f.length(), localfileis, smtpos);

       System.out.println("MAILLOG: Sent...");
       command = "\n.\nQUIT\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILLOG: Closing streams...");
       smtpos.flush();
       smtpos.close();
       localfileis.close();
       System.out.println("MAILLOG: Done mailing.");
   }

   private void cmdMailUrl(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String filetomail = unditchSpaces(st.nextToken());
       String sSmtpServer = unditchSpaces(st.nextToken());
       String sSendToWhom = st.nextToken();

       sSmtpServer = translateDNS(sSmtpServer);

       System.out.println("MAILURL: Trying to mail "+filetomail+" to "+sSmtpServer+":25...");

       boolean gotConnection = false;
       Socket smtpsocket = null;
       System.out.println("MAILURL: Trying to open SMTP server "+sSmtpServer+":25...");
       do {
           try {
       	    smtpsocket = new Socket(sSmtpServer, 25);
               gotConnection = true;
           } catch (java.net.ConnectException e) {
               System.out.println("MAILURL: Connection refused, will try again in 10s..");
               gotConnection = false;
               try { Thread.sleep(10000); } catch (InterruptedException ez) {}
           }
       } while( (gotConnection == false) || (smtpsocket == null) );
       System.out.println("MAILURL: Connected to SMTP server @ "+sSmtpServer+":25.  Mailing file...");
       OutputStream smtpos = smtpsocket.getOutputStream();

       //now construct URL
       URL sourceurl = new URL(jobfile, filetomail);
       //open connection
       URLConnection sourceurlc = sourceurl.openConnection();
       sourceurlc.connect();
       InputStream remotefileis = sourceurlc.getInputStream();

       String command = "HELO "+InetAddress.getLocalHost().getHostName()+"\nMAIL FROM: "+prodShort+"@"+InetAddress.getLocalHost().getHostName()+"\nRCPT TO: "+sSendToWhom+"\nDATA\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILURL: Copying...");
       command = "Subject: BackTalk mail: "+filetomail+"\nOn "+(new Date())+", BackTalk was instructed to send the url\n"+filetomail+"\nfrom "+InetAddress.getLocalHost().getHostName()+" / "+InetAddress.getLocalHost().getHostAddress()+"!\nHere is the file:\n\n";
       smtpos.write(command.getBytes());

       copyFileNoClose(sourceurlc.getContentLength(), remotefileis, smtpos);

       System.out.println("MAILURL: Sent...");
       command = "\n.\nQUIT\n";
       smtpos.write(command.getBytes());

       System.out.println("MAILURL: Closing streams...");
       smtpos.flush();
       smtpos.close();
       remotefileis.close();
       System.out.println("MAILURL: Done mailing.");
   }

   private void cmdTouchUrl(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String sourcefile = st.nextToken();

       //now construct URL
       URL sourceurl = new URL(jobfile, sourcefile);
       System.out.println("TOUCHURL: Reading 1 byte from "+sourceurl.toString()+"...");

       //open connection
       URLConnection sourceurlc = sourceurl.openConnection();
       sourceurlc.connect();
       InputStream remotefileis = sourceurlc.getInputStream();

       System.out.println("TOUCHURL: Closing streams...");
       remotefileis.read();
       remotefileis.close();

       System.out.println("TOUCHURL: Done touching.");
   }

   private void cmdTouchFile(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String sourcefile = unditchSpaces(st.nextToken());

       InputStream remotefileis = new FileInputStream(sourcefile);

       System.out.println("TOUCHFILE: Closing streams...");
       remotefileis.read();
       remotefileis.close();

       System.out.println("TOUCHFILE: Done touching.");
   }

   private void cmdDownload(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String sourcefile = st.nextToken();
       String destfile = unditchSpaces(st.nextToken());

       File f = new File(destfile);
       String fname = f.getCanonicalPath();
       int pos = fname.lastIndexOf('/');
       if(pos < 0) pos = fname.lastIndexOf('\\');

       f = new File(fname.substring(0, pos));
       f.mkdirs();

       //now construct URL
       URL sourceurl = new URL(jobfile, sourcefile);
       System.out.println("DOWNLOAD: Downloading "+sourceurl.toString()+" to "+destfile+"...");
       //open connection
       URLConnection sourceurlc = sourceurl.openConnection();
       sourceurlc.connect();
       InputStream remotefileis = sourceurlc.getInputStream();

       //now get the local file...
       OutputStream localfileos = new FileOutputStream(destfile);

       System.out.println("DOWNLOAD: Copying...");
       copyFile(sourceurlc.getContentLength(), remotefileis, localfileos);

       System.out.println("DOWNLOAD: Closing streams...");
       localfileos.flush();
       localfileos.close();
       remotefileis.close();
       System.out.println("DOWNLOAD: Done copying.");
   }

   private void cmdPrintUrl(StringTokenizer st, URL jobfile) throws Exception {
       //extract params
       String sourcefile = st.nextToken();
       String sPrinterIP = (st.nextToken());
       int port = Integer.parseInt(st.nextToken());

       sPrinterIP = translateDNS(sPrinterIP);

       //now construct URL
       URL sourceurl = new URL(jobfile, sourcefile);
       //open connection
       URLConnection sourceurlc = sourceurl.openConnection();
       sourceurlc.connect();
       InputStream remotefileis = sourceurlc.getInputStream();

       //now get the local file...
       //this is the Menlo-specific version.
       //Hopefully the printer IP doesn't change...
       //better yet, set an option for the config file...later?

       boolean gotConnection = false;
       Socket localfile = null;
       OutputStream localfileos = null;
       System.out.println("PRINTURL: Trying to open "+sPrinterIP+":"+port+"...");
       do {
           try {
       	    localfile = new Socket(sPrinterIP, port);
               gotConnection = true;
           } catch (java.net.ConnectException e) {
               System.out.println("PRINTURL: Connection refused, will try again in 10s..");
               gotConnection = false;
               try { Thread.sleep(10000); } catch (InterruptedException ez) {}
           }
       } while( (gotConnection == false) || (localfile == null) );
       System.out.println("PRINTURL: Connected to printer @ "+sPrinterIP+":"+port+".  Sending file...");
       localfileos = localfile.getOutputStream();

       System.out.println("PRINTURL: Printing...");
       copyFile(sourceurlc.getContentLength(), remotefileis, localfileos);

       System.out.println("PRINTURL: Closing streams...");
       localfileos.flush();
       localfileos.close();
       localfile.close();
       remotefileis.close();
       System.out.println("PRINTURL: Job sent to printer.");
   }

   private void copyFileNoClose(int length, InputStream i, OutputStream o) throws Exception {
       int in, read = 0;

       do {
           in = i.available();
           if(in < 1) continue;
           read += in;
           byte[] b = new byte[in];
           i.read(b);
           o.write(b);
       } while (read < length);
   }

   private void copyFile(int length, InputStream i, OutputStream o) throws Exception {
       copyFileNoClose(length, i, o);

       i.close();
       o.close();
   }

   public static String unditchSpaces(String ex) {
       StringBuffer result = new StringBuffer();
       for(int i=0;i<ex.length();i++) {
           char x = ex.charAt(i);
           if(x == '%') {
               char esc[] = {ex.charAt(i+1), ex.charAt(i+2)};
               String escape = new String(esc);
               i += 2;
               result.append((char)Integer.parseInt(escape, 16));
           } else {
               result.append(x);
           }
       }
       return result.toString();
   }
}
