import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

public class JCoolMenu extends JMenu implements MouseListener {

    public JCoolMenu() {this("");}
    public JCoolMenu(String s) {
       super(s);
       brMenuItemBorder = getBorder();
       brBevelBorder = new EtchedBorder();
       addMouseListener(this);
   }

   private Border brMenuItemBorder, brBevelBorder;

   public void mouseClicked(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {
       super.setBorder(brMenuItemBorder);
   }
   public void mouseReleased(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {
       if(!isSelected()) super.setBorder(brMenuItemBorder);
   }

   public void mouseEntered(MouseEvent e) {
       if(!isSelected()) super.setBorder(brBevelBorder);
   }

   public void setPopupMenuVisible(boolean b) {
      boolean isVisible = isPopupMenuVisible();
      if (b != isVisible) {
         // Set location of popupMenu (pulldown or pullright)
         // Perhaps this should be dictated by L&F
         if ((b==true) && isShowing()) {
            Point p = getPopupMenuOrigin();
            getPopupMenu().show(this, p.x, p.y);
         } else {
            getPopupMenu().setVisible(false);
         }
      }
   }

   protected Point getPopupMenuOrigin() {
      int x = 0;
      int y = 0;
      JPopupMenu pm = getPopupMenu();
      // Figure out the sizes needed to caclulate the menu position
      Dimension screenSize =Toolkit.getDefaultToolkit().getScreenSize();
      Dimension s = getSize();
      Dimension pmSize = pm.getSize();
      // For the first time the menu is popped up,
      // the size has not yet been initiated
      if (pmSize.width==0) {
         pmSize = pm.getPreferredSize();
      }
      Point position = getLocationOnScreen();
   
      Container parent = getParent();
      if (parent instanceof JPopupMenu) {
         // We are a submenu (pull-right)
   
         // First determine x:
         if (position.x+s.width + pmSize.width < screenSize.width) {
            x = s.width; // Prefer placement to the right
         } else {
      x = 0-pmSize.width; // Otherwise place to the left
      }
      // Then the y:
      if (position.y+pmSize.height < screenSize.height) {
         y = 0; // Prefer dropping down
      } else {
         y = s.height-pmSize.height; // Otherwise drop 'up'
      }
   } else {
   // We are a toplevel menu (pull-down)
   
   // First determine the x:
   if (position.x+pmSize.width < screenSize.width) {
      x = 0; // Prefer extending to right 
   } else {
      x = s.width-pmSize.width; // Otherwise extend to left
   }
   // Then the y:
   if (position.y+s.height+pmSize.height < screenSize.height) {
      y = s.height; // Prefer dropping down
      } else {
         y = 0-pmSize.height; // Otherwise drop 'up'
      }
   }
      return new Point(x,y);
   }
}
