import com.sun.image.codec.jpeg.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import javax.swing.border.*;
import javax.swing.*;
import java.util.*;

public class AtomicTable extends JPanel implements IPanelListener, ActionListener {
   private java.util.List layout;
   private Map elements, types, classes, states;
   private Map buttons = new HashMap();
   private PropertyPanelManager ppmgr;
   private StatusBar sb;

   private JButton btnSelected;
   private TElement teSelected;

   private JMenuItem miSaveTable = new JMenuItem("Save Table Image...", 'S');
   private JMenuItem miPrintTable = new JMenuItem("Print Table Image...", 'P');
   private JMenu pmContext = new JCoolMenu("Table");

   public AtomicTable(
       LoadStatusManager lsmgr,
       PropertyPanelManager pp,
       DatabaseManager dbmgr,
       ConfigManager cfgmgr,
       JPeriod99 parent,
       StatusBar s
   ) {
       layout = dbmgr.getLayout();
       elements = dbmgr.getElements();
       types = dbmgr.getTypes();
       classes = dbmgr.getClasses();
       states = dbmgr.getStates();
       ppmgr = pp;
       sb = s;

       ListIterator li = layout.listIterator();
       int w = Integer.parseInt((String)li.next());
       int h = Integer.parseInt((String)li.next());

       setBackground(Color.black);

       GridLayout g = new GridLayout(h, w, 5, 5);
       setLayout(g);

       Insets isx = new Insets(0,0,0,0);

       int ref = 0;
       TElement element;
       JButton btn;
       String value;

       for(int i=2;i<layout.size();i++){
           value = (String)li.next();

           if(Character.isDigit(value.charAt(0))) {
               //this means it's a number!
               ref = Integer.parseInt( value );
               if(ref != 0){
                   //add a button...
                   element = (TElement)elements.get(new Integer(ref));

                   btn = new JButton(element.Symbol);
                   btn.setMargin(isx);
                   btn.setActionCommand(Integer.toString(element.AtomicNumber));
                   btn.addActionListener(this);
                   btn.setBackground(TElementType.getTypeColor(element.ElementType, types));
                   btn.setToolTipText(element.Name+"("+element.AtomicNumber+")");
                   btn.setBorder(new LineBorder(TClass.getClassColor(element.ClassType, classes),2));
                   btn.setForeground(TState.getStateColor(element.State, states));

                   buttons.put(new Integer(element.AtomicNumber), btn);
                   add(btn);
               } else { add(new JLabel()); }
           } else {
               StringBuffer sb = new StringBuffer(value);
               sb.reverse();
               sb.setLength(sb.length()-1);
               sb.reverse();
               JLabel j = new JLabel(sb.toString(), SwingConstants.CENTER);
               j.setForeground(Color.white);
               add( j );
//               labels.addElement(j);
           }
       }
       ppmgr.addProperty(this);

       if(cfgmgr.canWriteFiles()) {
           miSaveTable.addActionListener(this);
           miSaveTable.setActionCommand("FileSaveTable");
           pmContext.add(miSaveTable);
       }

       if(cfgmgr.canPrint()) {
           miPrintTable.addActionListener(this);
           miPrintTable.setActionCommand("FilePrintTable");
           pmContext.add(miPrintTable);
       }
       pmContext.setMnemonic('T');
       JMenuBar mb = parent.getJMenuBar();
       mb.add(pmContext);
       mb.invalidate();
       mb.validate();
   }

   public void onDeactivate(PanelEvent pe) {}
   public void onActivate(PanelEvent pe) {}
   public void setAtom(PanelEvent pe) {
       TElement element = pe.getElement();
       JButton btn = (JButton) buttons.get(new Integer(element.AtomicNumber));
       if(btn == null) return;

       if(btnSelected != null) {
           btnSelected.setBackground(TElementType.getTypeColor(teSelected.ElementType, types));
           btnSelected.repaint();
       }

       btnSelected = btn;
       teSelected = element;
       btn.setBackground(btn.getBackground().darker());
       btn.repaint();
   }

   public void actionPerformed(ActionEvent e) {
       String s = e.getActionCommand();
       if(s.equals("FileSaveTable")) {
           OnFileSaveTable();
       } else if(s.equals("FilePrintTable")) {
       } else ppmgr.setAtom(Integer.parseInt(s));
   }

   public void setStyle(PanelEvent pe) {}

   private void OnFileSaveTable() {
     try {
	    SimpleFileFilter filter1 = new SimpleFileFilter("jpg", "JPEG image");
	    SimpleFileFilter filter2 = new SimpleFileFilter("bmp", "Windows Bitmap");
       javax.swing.filechooser.FileFilter f[] = {filter1, filter2};

       DoFileDialog d = new DoFileDialog(this, "Save Graph Image...", FileDialog.SAVE, f);
       String fname = d.getPath();

       if(fname.equals("")) return;

       String ext = DoFileDialog.getExtension(fname);

       Dimension dd = getSize();
       Image iBuffer = createImage(dd.width, dd.height);
       if(iBuffer == null) {System.err.println("ibuffer = null"); return;}
       Graphics gBuffer = iBuffer.getGraphics();
       if(gBuffer == null) {System.err.println("gBuffer = null"); return;}
       gBuffer.setClip(0, 0, dd.width, dd.height);
       paint(gBuffer);

       sb.setText("Saving "+fname+"...");
       if(ext.equals(".bmp")) {
       	BitmapCodec bf = new BitmapCodec(this);
       	bf.saveBitmap(fname, iBuffer);
       } else if(ext.equals(".jpg")) {
       	OutputStream out = new FileOutputStream(fname);
           JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
           encoder.encode((BufferedImage)iBuffer);
           out.flush();
           out.close();
       }
       sb.setText("Saved "+fname+".");
     } catch (Exception e){
       e.printStackTrace();
     }
   }

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
