import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import javax.swing.tree.*;
import java.awt.event.*;

class PropertyPanelManager implements TreeSelectionListener {
   private DatabaseManager dbmgr;
   private JTree tree;
   private DefaultTreeModel dtm;
   private Hashtable rootNodes;
   private java.util.Vector properties;
   private Container host;
   private JPeriod99 parent;
   private Hashtable elements;
   private int iSelection = -1;
   private TElement teSelection = null;

   private JFrame frmHolder;
   private Container cmpHolder;

   private IPanelListener currA;
   private Component currC;
   private IPanelListener panelListener = null;

   public static final String root = "Root";
   private DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode(root);

   public PropertyPanelManager(JTree t, DatabaseManager d, Container h, JPeriod99 p) {
       tree = t;
       dbmgr = d;
       host = h;
       parent = p;

       rootNodes = new Hashtable();
       properties = new Vector(50);

       frmHolder = new JFrame("Holder");
//       frmHolder.show();
       cmpHolder = frmHolder.getContentPane();

       elements = dbmgr.getElements();

       host.setLayout(new BorderLayout());

       dtm = new DefaultTreeModel(tnRoot);
       tree.setModel((TreeModel)dtm);
       rootNodes.put(root, tnRoot);
       tree.addTreeSelectionListener(this);
       tree.setEditable(false);
       tree.expandRow(0);
   }

   public void addRootNode(String caption) {
       DefaultMutableTreeNode tnNode = new DefaultMutableTreeNode(caption);
       tnRoot.add(tnNode);
       rootNodes.put(caption, tnNode);
   }

   public void addProperty(IPanelListener pl) {
       properties.addElement(pl);
       addPanelListener(pl);
   }

   public DefaultMutableTreeNode addPropertyPanel(String where, IPanelListener pl, Component c) {
       DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)rootNodes.get(where);
       if(dmtn == null) addRootNode(where);
       dmtn = (DefaultMutableTreeNode)rootNodes.get(where);

       DefaultMutableTreeNode dmtnn = new DefaultMutableTreeNode(c);

       if(dmtn == tnRoot) tnRoot.insert(dmtnn, 0);
       else dmtn.add(dmtnn);

       addProperty(pl);

       cmpHolder.add(c);

       return dmtnn;
   }

   public void addDefaultPropertyPanel(String where, IPanelListener pl, Component c) {
       DefaultMutableTreeNode dmtn = addPropertyPanel(where, pl, c);
       tree.setSelectionPath(new TreePath(dmtn.getPath()));
       valueChanged(null); //We have to give it a kick to get it to go!       
   }

   public void valueChanged(TreeSelectionEvent e) {
       TreePath p = tree.getSelectionPath();
       if(p == null) return;
       DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)p.getLastPathComponent();
       try {
           IPanelListener a = (IPanelListener) dmtn.getUserObject();
           Component c = (Component) dmtn.getUserObject();

           cmpHolder.remove(c);

           if(currA != null) {
               currA.onDeactivate(new PanelEvent(PanelEvent.WM_DEACTIVATE, this, null, 0));
               host.remove(currC);
               cmpHolder.add(currC);
           }

           host.add("Center", c);
           a.onActivate(new PanelEvent(PanelEvent.WM_ACTIVATE, this, null, 0));

           currA = a;
           currC = c;

           c.invalidate();
           c.repaint();
           host.invalidate();
           host.validate();
       } catch (ClassCastException ex) {;}
         catch (NullPointerException ex) {;}
   }

   public TElement getSelection() {return teSelection;}
   public void setSelection(TElement set) {setAtom(set.AtomicNumber);}

   public int getAtom() {return iSelection;}
   public void setAtom(int atom) {
       if(null == panelListener) return;

       iSelection = atom;
       teSelection = (TElement)elements.get(new Integer(atom));
       PanelEvent pe = new PanelEvent(PanelEvent.WM_SELECTATOM, this, teSelection, 0);
       panelListener.setAtom(pe);
   }

   public void setStyle(int style) {
       if(null == panelListener) return;
       PanelEvent pe = new PanelEvent(PanelEvent.WM_SETSTYLE, this, null, style);
       panelListener.setStyle(pe);
   }

   public void addPanelListener(IPanelListener pl) {
       panelListener = PanelEventMulticaster.add(panelListener, pl);
   }

   public void removePanelListener(IPanelListener pl) {
       panelListener = PanelEventMulticaster.remove(panelListener, pl);
   }

   public void addMenu(JMenu a) {
       JMenuBar mb = parent.getJMenuBar();
       mb.add(a);
       mb.invalidate();
       mb.validate();
   }

   public void removeMenu(JMenu r){
       JMenuBar mb = parent.getJMenuBar();
       mb.remove(r);
       mb.repaint();
   }

   public void updateComponentTreeUI() {
       SwingUtilities.updateComponentTreeUI(frmHolder);
   }
}
