import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.util.*;

public class BodyMeasurement extends JPanel implements IPanelListener, ActionListener, ItemListener {
   private float multiplier = (float) 0.0;
   private JTextField eInput = new JTextField("0.0", 8);
   private JComboBox cbUnits;
   private JTextField eOutput = new JTextField("0.0", 8);
   private JButton bCalc = new JButton("Calculate");
   private Hashtable elements;
   private JLabel l1 = new JLabel("For every");
   private JLabel l2 = new JLabel("you weigh, there are");
   private JLabel l3 = new JLabel("g of this element in your body.");
   private JLabel lCaption = new JLabel("How much of this element in your body?");
   private JPanel pControls = new JPanel();
   private JPanel pLabel = new JPanel();

   public String toString() {return "Body Measurement";}

   public BodyMeasurement() {
       DefaultComboBoxModel dcbm = new DefaultComboBoxModel();
       dcbm.addElement("kg");
       dcbm.addElement("lbs");
       cbUnits = new JComboBox(dcbm);

       pControls.setLayout(new FlowLayout(FlowLayout.CENTER));
       pControls.add(l1);
       pControls.add(eInput);
       pControls.add(cbUnits);
       pControls.add(l2);
       pControls.add(eOutput);
       pControls.add(l3);
       pControls.add(bCalc);

       eOutput.setEditable(false);
       eOutput.setBackground(getBackground());
       bCalc.addActionListener(this);
       cbUnits.addItemListener(this);

       setLayout(new BorderLayout());
       Font f = lCaption.getFont();
       lCaption.setFont(new Font(f.getName(), f.getStyle(), 20));
       add("North", lCaption);
       add("Center", pControls);
   }

   public void setAtom(PanelEvent pe) {
       multiplier = pe.getElement().gperkg;
       calculate();
   }

   private void calculate() {
       float in;
       try {
           in = Float.valueOf(eInput.getText()).floatValue();
       } catch(NumberFormatException e) {
           JOptionPane.showMessageDialog(null, "You must enter a number for your body weight.", "Bad number format!", JOptionPane.ERROR_MESSAGE);
           return;
       }

       if(in < 0.0) {
           JOptionPane.showMessageDialog(null, "Negative body weight is not possible.", "Bad number!", JOptionPane.ERROR_MESSAGE);
           return;
       }

       DefaultComboBoxModel dcbm = (DefaultComboBoxModel)cbUnits.getModel();
       int x = dcbm.getIndexOf(dcbm.getSelectedItem());
       if(x == 1) in /= 2.2046; //convert lbs to kg.
       eOutput.setText(Float.toString(in * multiplier));
   }

   public void actionPerformed(ActionEvent e) {calculate();}
   public void itemStateChanged(ItemEvent e) {calculate();}
   public void onActivate(PanelEvent pe) {}
   public void onDeactivate(PanelEvent pe) {}

   public void setStyle(PanelEvent pe) {}
}
