/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class IonEnthalpy
extends JScrollPane
implements IPanelListener,
ActionListener {
    private PropertyPanelManager ppmgr;
    private JTable j = new JTable();
    private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 67);
    private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");

    public IonEnthalpy(ConfigManager configManager, PropertyPanelManager propertyPanelManager) {
        this.ppmgr = propertyPanelManager;
        Font font = this.j.getFont();
        this.j.setFont(new Font(font.getName(), 0, 20));
        this.j.setRowHeight(this.j.getRowHeight() + 10);
        this.j.setSelectionMode(0);
        this.j.setCellSelectionEnabled(false);
        this.setViewportView(this.j);
        if (configManager.canGetClipboard()) {
            this.miCopyToClipboard.addActionListener(this);
            this.miCopyToClipboard.setActionCommand("CopyToClipboard");
            this.pmContext.add(this.miCopyToClipboard);
        }
        if (configManager.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintText");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    private void OnCopyToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.j.getRowCount();
        int n2 = this.j.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(this.j.getColumnName(n3));
            ++n3;
        }
        stringBuffer.append("\r\n");
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                stringBuffer.append(this.j.getValueAt(n4, n5).toString());
                stringBuffer.append("\t");
                ++n5;
            }
            stringBuffer.append("\r\n");
            ++n4;
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void OnFilePrintText() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CopyToClipboard")) {
            this.OnCopyToClipboard();
        } else if (string.equals("FilePrintText")) {
            this.OnFilePrintText();
        }
    }

    public void onActivate(PanelEvent panelEvent) {
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        float[] fArray = tElement.enthalpies;
        Object[] objectArray = new String[]{"Electron", "Enthalpy (kJ/mol)"};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        int n = 0;
        while (n < fArray.length) {
            Object[] objectArray2 = new Object[]{new Integer(n), new Float(fArray[n])};
            defaultTableModel.addRow(objectArray2);
            ++n;
        }
        this.j.setModel(defaultTableModel);
        this.j.repaint();
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public String toString() {
        return "Ionization Enthalpies";
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

