/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AtomAni
extends JPanel
implements IPanelListener,
Runnable,
ActionListener,
ChangeListener {
    public atom model;
    private JButton start = new JButton("Start");
    private JButton stop = new JButton("Stop");
    private JSlider speed = new JSlider(0, 2000, 500);
    private JLabel lSpeed = new JLabel("500ms");
    private Thread t;
    private BufferedImage iBuffer;
    private int delay = 500;
    private int radius;
    private boolean killNow = false;

    public AtomAni() {
        this.setLayout(new FlowLayout(0));
        this.add(this.start);
        this.start.addActionListener(this);
        this.add(this.stop);
        this.stop.addActionListener(this);
        this.add(this.lSpeed);
        this.add(this.speed);
        this.speed.addChangeListener(this);
        this.lSpeed.setForeground(Color.white);
        this.setBackground(Color.black);
        int n = Math.min(this.getSize().width, this.getSize().height);
        this.model = new atom(1, 1, n, n);
        this.startDraw();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.start) {
            this.startDraw();
        } else if (actionEvent.getSource() == this.stop) {
            this.stopDraw();
        }
    }

    public BufferedImage createBufferedImage(int n, int n2, int n3) {
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(n, n2, n3);
        return bufferedImage;
    }

    private void fixG2D(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setFont(this.getFont());
    }

    public void onActivate(PanelEvent panelEvent) {
        this.startDraw();
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.stopDraw();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (this.iBuffer == null || this.radius != n) {
            this.iBuffer = this.createBufferedImage(n, n, 5);
            int n2 = this.model.AtomicNumber;
            this.model = new atom(n2, n2, n, n);
            this.radius = n;
        }
        Graphics2D graphics2D = (Graphics2D)this.iBuffer.getGraphics();
        this.fixG2D(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.fill(new Rectangle(0, 0, dimension.width, dimension.height));
        graphics2D.setColor(Color.white);
        this.model.draw(graphics2D, n / 2, n / 2);
        graphics.drawImage(this.iBuffer, dimension.width - n, (dimension.height - n) / 2, null, null);
    }

    public void run() {
        while (!this.killNow) {
            this.repaint();
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        return;
    }

    public void setAtom(PanelEvent panelEvent) {
        this.model.setAtomicNumber(panelEvent.getElement().AtomicNumber);
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    private void startDraw() {
        this.killNow = false;
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.delay = this.speed.getValue();
        this.lSpeed.setText(String.valueOf(this.delay) + "ms");
    }

    private void stopDraw() {
        this.killNow = true;
    }

    public String toString() {
        return "Electron Animation";
    }
}

